/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingContainer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(StreamConsumerSettings.class);
    public static final String PROP_EXTRACT_IMAGES = "extractImages";
    public static final String PROP_FILE_EXTENSION = "extension";
    private static final String SETTING_VALUE_FORMAT = "valueFormat";
    private LobExtractType lobExtractType = LobExtractType.INLINE;
    private LobEncoding lobEncoding = LobEncoding.BINARY;
    private String outputFolder = System.getProperty("user.home");
    private String outputFilePattern = String.valueOf(GeneralUtils.variablePattern((String)"table")) + "_" + GeneralUtils.variablePattern((String)"timestamp");
    private String outputEncoding = GeneralUtils.getDefaultFileEncoding();
    private boolean outputEncodingBOM = false;
    private String outputTimestampPattern = "yyyyMMddHHmm";
    private DBDDataFormatterProfile formatterProfile;
    @NotNull
    private DBDDisplayFormat valueFormat = DBDDisplayFormat.UI;
    private boolean outputClipboard = false;
    private boolean useSingleFile = false;
    private boolean compressResults = false;
    private boolean splitOutFiles = false;
    private long maxOutFileSize = 10000000L;
    private final Map<DBSDataContainer, StreamMappingContainer> dataMappings = new LinkedHashMap<DBSDataContainer, StreamMappingContainer>();
    private final Map<String, Map<String, Object>> eventProcessors = new HashMap<String, Map<String, Object>>();

    public LobExtractType getLobExtractType() {
        return this.lobExtractType;
    }

    public void setLobExtractType(LobExtractType lobExtractType) {
        this.lobExtractType = lobExtractType;
    }

    public LobEncoding getLobEncoding() {
        return this.lobEncoding;
    }

    public void setLobEncoding(LobEncoding lobEncoding) {
        this.lobEncoding = lobEncoding;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean isOutputEncodingBOM() {
        return this.outputEncodingBOM;
    }

    public void setOutputEncodingBOM(boolean outputEncodingBOM) {
        this.outputEncodingBOM = outputEncodingBOM;
    }

    public String getOutputTimestampPattern() {
        return this.outputTimestampPattern;
    }

    public void setOutputTimestampPattern(String outputTimestampPattern) {
        this.outputTimestampPattern = outputTimestampPattern;
    }

    public boolean isOutputClipboard() {
        return this.outputClipboard;
    }

    public void setOutputClipboard(boolean outputClipboard) {
        this.outputClipboard = outputClipboard;
    }

    public boolean isUseSingleFile() {
        return this.useSingleFile;
    }

    public void setUseSingleFile(boolean useSingleFile) {
        this.useSingleFile = useSingleFile;
    }

    public boolean isCompressResults() {
        return this.compressResults;
    }

    public void setCompressResults(boolean compressResults) {
        this.compressResults = compressResults;
    }

    public boolean isSplitOutFiles() {
        return this.splitOutFiles;
    }

    public void setSplitOutFiles(boolean splitOutFiles) {
        this.splitOutFiles = splitOutFiles;
    }

    public long getMaxOutFileSize() {
        return this.maxOutFileSize;
    }

    public void setMaxOutFileSize(long maxOutFileSize) {
        this.maxOutFileSize = maxOutFileSize;
    }

    @NotNull
    public Map<DBSDataContainer, StreamMappingContainer> getDataMappings() {
        return this.dataMappings;
    }

    @Nullable
    public StreamMappingContainer getDataMapping(@NotNull DBSDataContainer container) {
        return this.dataMappings.get(container);
    }

    public void addDataMapping(@NotNull StreamMappingContainer container) {
        this.dataMappings.put(container.getSource(), container);
    }

    @NotNull
    public Map<String, Object> getEventProcessorSettings(@NotNull String id) {
        return this.eventProcessors.computeIfAbsent(id, x -> new HashMap());
    }

    public void addEventProcessor(@NotNull String id) {
        this.eventProcessors.putIfAbsent(id, new HashMap());
    }

    public void removeEventProcessor(@NotNull String id) {
        this.eventProcessors.remove(id);
    }

    public boolean hasEventProcessor(@NotNull String id) {
        return this.eventProcessors.containsKey(id);
    }

    @NotNull
    public Map<String, Map<String, Object>> getEventProcessors() {
        return this.eventProcessors;
    }

    public DBDDataFormatterProfile getFormatterProfile() {
        return this.formatterProfile;
    }

    public void setFormatterProfile(DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.lobExtractType = (LobExtractType)CommonUtils.valueOf(LobExtractType.class, (String)CommonUtils.toString((Object)settings.get("lobExtractType")), (Enum)LobExtractType.INLINE);
        this.lobEncoding = (LobEncoding)CommonUtils.valueOf(LobEncoding.class, (String)CommonUtils.toString((Object)settings.get("lobEncoding")), (Enum)LobEncoding.BINARY);
        this.outputFolder = CommonUtils.toString((Object)settings.get("outputFolder"), (String)this.outputFolder);
        this.outputFilePattern = CommonUtils.toString((Object)settings.get("outputFilePattern"), (String)this.outputFilePattern);
        this.outputEncoding = CommonUtils.toString((Object)settings.get("outputEncoding"), (String)this.outputEncoding);
        this.outputTimestampPattern = CommonUtils.toString((Object)settings.get("outputTimestampPattern"), (String)this.outputTimestampPattern);
        this.outputEncodingBOM = CommonUtils.getBoolean((Object)settings.get("outputEncodingBOM"), (boolean)this.outputEncodingBOM);
        this.outputClipboard = CommonUtils.getBoolean((Object)settings.get("outputClipboard"), (boolean)this.outputClipboard);
        this.useSingleFile = dataTransferSettings.getDataPipes().size() > 1 ? CommonUtils.getBoolean((Object)settings.get("useSingleFile"), (boolean)this.useSingleFile) : false;
        this.compressResults = CommonUtils.getBoolean((Object)settings.get("compressResults"), (boolean)this.compressResults);
        this.splitOutFiles = CommonUtils.getBoolean((Object)settings.get("splitOutFiles"), (boolean)this.splitOutFiles);
        this.maxOutFileSize = CommonUtils.toLong((Object)settings.get("maxOutFileSize"), (long)this.maxOutFileSize);
        boolean openFolderOnFinish = CommonUtils.getBoolean((Object)settings.get("openFolderOnFinish"), (boolean)false);
        boolean executeProcessOnFinish = CommonUtils.getBoolean((Object)settings.get("executeProcessOnFinish"), (boolean)false);
        String finishProcessCommand = CommonUtils.toString((Object)settings.get("finishProcessCommand"));
        String formatterProfile = CommonUtils.toString((Object)settings.get("formatterProfile"));
        if (!CommonUtils.isEmpty((String)formatterProfile)) {
            this.formatterProfile = DBWorkbench.getPlatform().getDataFormatterRegistry().getCustomProfile(formatterProfile);
        }
        this.valueFormat = DBDDisplayFormat.safeValueOf((String)CommonUtils.toString((Object)settings.get(SETTING_VALUE_FORMAT)));
        Map mappings = JSONUtils.getObjectOrNull(settings, (String)"mappings");
        if (mappings != null && !mappings.isEmpty()) {
            try {
                runnableContext.run(true, true, monitor -> {
                    List<DataTransferPipe> pipes = dataTransferSettings.getDataPipes();
                    for (DataTransferPipe pipe : pipes) {
                        DBSDataContainer container;
                        Map containerSettings;
                        DBSObject object;
                        IDataTransferProducer<?> producer = pipe.getProducer();
                        if (producer == null || !((object = producer.getDatabaseObject()) instanceof DBSDataContainer) || (containerSettings = JSONUtils.getObjectOrNull((Map)mappings, (String)DBUtils.getObjectFullId((DBSObject)(container = (DBSDataContainer)object)))) == null) continue;
                        StreamMappingContainer mappingContainer = new StreamMappingContainer(container);
                        mappingContainer.loadSettings(monitor, containerSettings);
                        this.addDataMapping(mappingContainer);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError(DTMessages.stream_transfer_consumer_title_configuration_load_failed, DTMessages.stream_transfer_consumer_message_cannot_load_configuration, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Canceled by user", (Throwable)e);
            }
        }
        Map processors = JSONUtils.getObject(settings, (String)"eventProcessors");
        for (String processor : processors.keySet()) {
            this.eventProcessors.put(processor, JSONUtils.getObject((Map)processors, (String)processor));
        }
        if (openFolderOnFinish && !this.eventProcessors.containsKey("showInExplorer")) {
            this.eventProcessors.put("showInExplorer", Collections.emptyMap());
        }
        if (executeProcessOnFinish && !this.eventProcessors.containsKey("executeCommand")) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("command", finishProcessCommand);
            config.put("workingDirectory", null);
            this.eventProcessors.put("executeCommand", config);
        }
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        settings.put("lobExtractType", this.lobExtractType.name());
        settings.put("lobEncoding", this.lobEncoding.name());
        settings.put("outputFolder", this.outputFolder);
        settings.put("outputFilePattern", this.outputFilePattern);
        settings.put("outputEncoding", this.outputEncoding);
        settings.put("outputTimestampPattern", this.outputTimestampPattern);
        settings.put("outputEncodingBOM", this.outputEncodingBOM);
        settings.put("outputClipboard", this.outputClipboard);
        settings.put("useSingleFile", this.useSingleFile);
        settings.put("compressResults", this.compressResults);
        settings.put("splitOutFiles", this.splitOutFiles);
        settings.put("maxOutFileSize", this.maxOutFileSize);
        if (this.formatterProfile != null) {
            settings.put("formatterProfile", this.formatterProfile.getProfileName());
        } else {
            settings.put("formatterProfile", "");
        }
        settings.put(SETTING_VALUE_FORMAT, this.valueFormat.name());
        if (!this.dataMappings.isEmpty()) {
            LinkedHashMap<String, LinkedHashMap<String, Object>> mappings = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            for (StreamMappingContainer container : this.dataMappings.values()) {
                LinkedHashMap<String, Object> containerSettings = new LinkedHashMap<String, Object>();
                container.saveSettings(containerSettings);
                mappings.put(DBUtils.getObjectFullId((DBSObject)container.getSource()), containerSettings);
            }
            settings.put("mappings", mappings);
        }
        if (!this.eventProcessors.isEmpty()) {
            settings.put("eventProcessors", this.eventProcessors);
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        if (!this.outputClipboard) {
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_use_single_file, this.useSingleFile);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_directory, this.outputFolder);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_file_name_pattern, this.outputFilePattern);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_encoding, this.outputEncoding);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_timestamp_pattern, this.outputTimestampPattern);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_insert_bom, this.outputEncodingBOM);
        } else {
            DTUtils.addSummary(summary, "Copy to clipboard", this.outputClipboard);
        }
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_compress, this.compressResults);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_binaries, (Object)this.lobExtractType);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_encoding, (Object)this.lobEncoding);
        if (this.formatterProfile != null) {
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_formatting, this.formatterProfile.getProfileName());
        }
        return summary.toString();
    }

    @NotNull
    public DBDDisplayFormat getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(@NotNull DBDDisplayFormat valueFormat) {
        this.valueFormat = valueFormat;
    }

    public static enum LobEncoding {
        BASE64,
        HEX,
        BINARY,
        NATIVE;

    }

    public static enum LobExtractType {
        SKIP,
        FILES,
        INLINE;

    }
}

