/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.updater;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.registry.updater.DistributionDescriptor;
import org.jkiss.dbeaver.registry.updater.UpdateSiteDescriptor;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

public class VersionDescriptor {
    private String programName;
    private Version programVersion;
    private String updateTime;
    private String baseURL;
    private String downloadURL;
    private String releaseNotes;
    private final List<DistributionDescriptor> distributions = new ArrayList<DistributionDescriptor>();
    private final List<UpdateSiteDescriptor> updateSites = new ArrayList<UpdateSiteDescriptor>();

    public VersionDescriptor(DBPPlatform platform, String fileAddr) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = WebUtils.openConnection((String)fileAddr, (String)platform.getWorkspace().getWorkspaceId()).getInputStream();){
                this.parseVersionInfo(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLException e) {
            throw new IOException("XML parse error", e);
        }
    }

    public String getProgramName() {
        return this.programName;
    }

    public Version getProgramVersion() {
        return this.programVersion;
    }

    public void setProgramVersion(Version programVersion) {
        this.programVersion = programVersion;
    }

    public String getPlainVersion() {
        return String.valueOf(this.programVersion.getMajor()) + "." + this.programVersion.getMinor() + "." + this.programVersion.getMicro();
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Date getVersionReleaseTimestamp() {
        try {
            return new SimpleDateFormat("dd.MM.yyyy").parse(this.updateTime);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public Collection<DistributionDescriptor> getDistributions() {
        return this.distributions;
    }

    public Collection<UpdateSiteDescriptor> getUpdateSites() {
        return this.updateSites;
    }

    private void parseVersionInfo(InputStream inputStream) throws IOException, XMLException {
        SAXReader parser = new SAXReader(inputStream);
        SAXListener dsp = new SAXListener(){
            private String lastTag;
            private StringBuilder textBuffer = new StringBuilder();

            public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
                this.lastTag = localName;
                this.textBuffer.setLength(0);
            }

            public void saxText(SAXReader reader, String data) throws XMLException {
                this.textBuffer.append(data);
            }

            public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
                String text = this.textBuffer.toString();
                switch (this.lastTag) {
                    case "name": {
                        VersionDescriptor.this.programName = text;
                        break;
                    }
                    case "number": {
                        VersionDescriptor.this.programVersion = Version.parseVersion((String)text);
                        break;
                    }
                    case "date": {
                        VersionDescriptor.this.updateTime = text;
                        break;
                    }
                    case "base-url": {
                        VersionDescriptor.this.baseURL = text;
                        break;
                    }
                    case "download-url": {
                        VersionDescriptor.this.downloadURL = text;
                        break;
                    }
                    case "release-notes": {
                        VersionDescriptor.this.releaseNotes = text;
                    }
                }
                this.textBuffer.setLength(0);
            }
        };
        parser.parse(dsp);
    }
}

