/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.maven;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.registry.maven.IMavenIdentifier;
import org.jkiss.utils.CommonUtils;

public class MavenArtifactReference
implements IMavenIdentifier {
    public static final String VERSION_PATTERN_RELEASE = "RELEASE";
    public static final String VERSION_PATTERN_LATEST = "LATEST";
    public static final String VERSION_PATTERN_SNAPSHOT = "SNAPSHOT";
    private static final String DEFAULT_MAVEN_VERSION = "RELEASE";
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private final String version;
    @NotNull
    private final String id;
    @Nullable
    private final String classifier;
    private boolean resolveOptionalDependencies;

    public MavenArtifactReference(@NotNull String groupId, @NotNull String artifactId, @Nullable String classifier, @NotNull String version) {
        this.groupId = CommonUtils.trim((String)groupId);
        this.artifactId = CommonUtils.trim((String)artifactId);
        this.version = CommonUtils.trim((String)version);
        this.classifier = CommonUtils.trim((String)classifier);
        this.id = MavenArtifactReference.makeId(this);
    }

    public MavenArtifactReference(String ref) {
        String mavenUri = ref;
        int divPos = mavenUri.indexOf(47);
        if (divPos >= 0) {
            mavenUri = mavenUri.substring(divPos + 1);
        }
        if ((divPos = mavenUri.indexOf(58)) < 0) {
            this.groupId = mavenUri;
            this.artifactId = mavenUri;
            this.classifier = null;
            this.version = "RELEASE";
        } else {
            this.groupId = mavenUri.substring(0, divPos);
            int divPos2 = mavenUri.indexOf(58, divPos + 1);
            if (divPos2 < 0) {
                this.artifactId = mavenUri.substring(divPos + 1);
                this.classifier = null;
                this.version = "RELEASE";
            } else {
                int divPos3 = mavenUri.indexOf(58, divPos2 + 1);
                if (divPos3 < 0) {
                    this.artifactId = mavenUri.substring(divPos + 1, divPos2);
                    this.classifier = null;
                    this.version = mavenUri.substring(divPos2 + 1);
                } else {
                    this.artifactId = mavenUri.substring(divPos + 1, divPos2);
                    this.classifier = mavenUri.substring(divPos2 + 1, divPos3);
                    this.version = mavenUri.substring(divPos3 + 1);
                }
            }
        }
        this.id = MavenArtifactReference.makeId(this);
    }

    @Override
    @NotNull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @NotNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public String getPath() {
        return String.valueOf(this.id) + ":" + this.version;
    }

    public boolean isResolveOptionalDependencies() {
        return this.resolveOptionalDependencies;
    }

    public void setResolveOptionalDependencies(boolean resolveOptionalDependencies) {
        this.resolveOptionalDependencies = resolveOptionalDependencies;
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.groupId.hashCode() + this.artifactId.hashCode() + this.version.hashCode();
    }

    static String makeId(IMavenIdentifier identifier) {
        if (identifier.getClassifier() != null) {
            return String.valueOf(identifier.getGroupId()) + ":" + identifier.getArtifactId() + ":" + identifier.getClassifier();
        }
        return String.valueOf(identifier.getGroupId()) + ":" + identifier.getArtifactId();
    }
}

