/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class NumericAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(NumericAttributeTransformer.class);
    private static final String PROP_TYPE = "type";
    private static final String PROP_LENIENT = "lenient";

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        String type = CommonUtils.toString((Object)options.get(PROP_TYPE), (String)"double");
        boolean lenient = CommonUtils.getBoolean((Object)options.get(PROP_LENIENT), (boolean)false);
        attribute.setTransformHandler(new NumericValueHandler(attribute.getValueHandler(), type, lenient));
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "numeric", -1, DBPDataKind.NUMERIC));
    }

    private static class NumericValueHandler
    extends ProxyValueHandler {
        private final String type;
        private final boolean lenient;

        public NumericValueHandler(@NotNull DBDValueHandler target, @NotNull String type, boolean lenient) {
            super(target);
            this.type = type;
            this.lenient = lenient;
        }

        @Override
        @NotNull
        public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
            return Object.class;
        }

        @Override
        public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
            super.bindValueObject(session, statement, type, index, CommonUtils.toString((Object)value));
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
            if (object instanceof String) {
                object = NumericValueHandler.parseValue((String)object, this.type, this.lenient);
            }
            if (object instanceof Number) {
                return object;
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (value instanceof String) {
                value = NumericValueHandler.parseValue((String)value, this.type, this.lenient);
            }
            if (value instanceof Number) {
                return CommonUtils.toString((Object)value);
            }
            if (value == null) {
                return "";
            }
            return super.getValueDisplayString(column, value, format);
        }

        @Nullable
        private static Object parseValue(@NotNull String value, @NotNull String type, boolean lenient) {
            try {
                switch (type) {
                    case "byte": {
                        return Byte.parseByte(value);
                    }
                    case "short": {
                        return Short.parseShort(value);
                    }
                    case "int": {
                        return Integer.parseInt(value);
                    }
                    case "long": {
                        return Long.parseLong(value);
                    }
                    case "float": {
                        return Float.valueOf(Float.parseFloat(value));
                    }
                    case "double": {
                        return Double.parseDouble(value);
                    }
                }
                return null;
            }
            catch (NumberFormatException e) {
                if (lenient) {
                    log.trace("Error converting string '" + value + "' to " + type, e);
                    return value;
                }
                throw e;
            }
        }
    }
}

