/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.text;

import java.util.List;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.text.FlowBox;
import org.eclipse.draw2dl.text.FlowContext;
import org.eclipse.draw2dl.text.FlowFigure;
import org.eclipse.draw2dl.text.FlowFigureLayout;
import org.eclipse.draw2dl.text.LineBox;

public abstract class FlowContainerLayout
extends FlowFigureLayout
implements FlowContext {
    LineBox currentLine;

    protected FlowContainerLayout(FlowFigure flowFigure) {
        super(flowFigure);
    }

    @Override
    public void addToCurrentLine(FlowBox child) {
        this.getCurrentLine().add(child);
        this.setContinueOnSameLine(false);
    }

    protected void cleanup() {
        this.currentLine = null;
    }

    protected abstract void createNewLine();

    protected abstract void flush();

    LineBox getCurrentLine() {
        if (this.currentLine == null) {
            this.createNewLine();
        }
        return this.currentLine;
    }

    @Override
    public int getRemainingLineWidth() {
        return this.getCurrentLine().getAvailableWidth();
    }

    @Override
    public boolean isCurrentLineOccupied() {
        return this.currentLine != null && this.currentLine.isOccupied();
    }

    @Override
    protected void layout() {
        this.preLayout();
        this.layoutChildren();
        this.flush();
        this.cleanup();
    }

    protected void layoutChildren() {
        List<IFigure> children = this.getFlowFigure().getChildren();
        for (IFigure child : children) {
            Figure f = (Figure)child;
            if (this.forceChildInvalidation(f)) {
                f.invalidate();
            }
            f.validate();
        }
    }

    boolean forceChildInvalidation(Figure f) {
        return true;
    }

    protected abstract void preLayout();
}

