/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.palette;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.gef3.palette.PaletteContainer;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteEntry {
    public static final String PROPERTY_SMALL_ICON = "Small Icon";
    public static final String PROPERTY_TYPE = "Type";
    public static final String PROPERTY_LARGE_ICON = "Large Icon";
    public static final String PROPERTY_LABEL = "Name";
    public static final String PROPERTY_DESCRIPTION = "Description";
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_DEFAULT = "Default";
    public static final String PROPERTY_PARENT = "Parent";
    public static final String PALETTE_TYPE_UNKNOWN = "Palette_type_Unknown";
    public static final int PERMISSION_NO_MODIFICATION = 1;
    public static final int PERMISSION_HIDE_ONLY = 3;
    public static final int PERMISSION_LIMITED_MODIFICATION = 7;
    public static final int PERMISSION_FULL_MODIFICATION = 15;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private PaletteContainer parent;
    private String label;
    private String id;
    private String shortDescription;
    private ImageDescriptor iconSmall;
    private ImageDescriptor iconLarge;
    private boolean visible = true;
    private int permission = 15;
    private Object type = "Palette_type_Unknown";

    public PaletteEntry(String label, String shortDescription) {
        this(label, shortDescription, null, null, null);
    }

    public PaletteEntry(String label, String shortDescription, Object type) {
        this(label, shortDescription, null, null, type);
    }

    public PaletteEntry(String label, String shortDescription, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
        this(label, shortDescription, iconSmall, iconLarge, null);
    }

    public PaletteEntry(String label, String shortDescription, ImageDescriptor iconSmall, ImageDescriptor iconLarge, Object type) {
        this(label, shortDescription, iconSmall, iconLarge, type, null);
    }

    public PaletteEntry(String label, String shortDescription, ImageDescriptor smallIcon, ImageDescriptor largeIcon, Object type, String id) {
        this.setLabel(label);
        this.setDescription(shortDescription);
        this.setSmallIcon(smallIcon);
        this.setLargeIcon(largeIcon);
        this.setType(type);
        this.setId(id);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public String getDescription() {
        return this.shortDescription;
    }

    public String getId() {
        if (this.id == null) {
            return "";
        }
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public ImageDescriptor getLargeIcon() {
        return this.iconLarge;
    }

    public PaletteContainer getParent() {
        return this.parent;
    }

    public ImageDescriptor getSmallIcon() {
        return this.iconSmall;
    }

    public Object getType() {
        return this.type;
    }

    public int getUserModificationPermission() {
        return this.permission;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setDescription(String s) {
        if (s == null && this.shortDescription == null) {
            return;
        }
        if (s == null || !s.equals(this.shortDescription)) {
            String oldDescrption = this.shortDescription;
            this.shortDescription = s;
            this.listeners.firePropertyChange(PROPERTY_DESCRIPTION, oldDescrption, this.shortDescription);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String s) {
        if (s == null && this.label == null) {
            return;
        }
        if (s == null || !s.equals(this.label)) {
            String oldLabel = this.label;
            this.label = s;
            this.listeners.firePropertyChange(PROPERTY_LABEL, oldLabel, this.label);
        }
    }

    public void setLargeIcon(ImageDescriptor icon) {
        if (icon != this.iconLarge) {
            ImageDescriptor oldIcon = this.iconLarge;
            this.iconLarge = icon;
            this.listeners.firePropertyChange(PROPERTY_LARGE_ICON, oldIcon, this.iconLarge);
        }
    }

    public void setParent(PaletteContainer newParent) {
        if (this.parent != newParent) {
            PaletteContainer oldParent = this.parent;
            this.parent = newParent;
            this.listeners.firePropertyChange(PROPERTY_PARENT, oldParent, this.parent);
        }
    }

    public void setSmallIcon(ImageDescriptor icon) {
        if (icon != this.iconSmall) {
            ImageDescriptor oldIcon = this.iconSmall;
            this.iconSmall = icon;
            this.listeners.firePropertyChange(PROPERTY_SMALL_ICON, oldIcon, icon);
        }
    }

    public void setType(Object newType) {
        if (newType == null && this.type == null) {
            return;
        }
        if (this.type == null || !this.type.equals(newType)) {
            Object oldType = this.type;
            this.type = newType;
            this.listeners.firePropertyChange(PROPERTY_TYPE, oldType, this.type);
        }
    }

    public void setUserModificationPermission(int permission) {
        this.permission = permission;
    }

    public void setVisible(boolean newVal) {
        if (newVal != this.visible) {
            this.visible = newVal;
            this.listeners.firePropertyChange(PROPERTY_VISIBLE, !this.visible, this.visible);
        }
    }

    public String toString() {
        return "Palette Entry (" + (this.label != null ? this.label : "") + ")";
    }
}

