/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.utils.CommonUtils;

final class SQLTranslateContext {
    @NotNull
    private final SQLDialect sourceDialect;
    @NotNull
    private final SQLDialect targetDialect;
    @NotNull
    private final DBPPreferenceStore preferenceStore;
    @NotNull
    private final SQLSyntaxManager syntaxManager;

    public SQLTranslateContext(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull DBPPreferenceStore preferenceStore) {
        this.sourceDialect = sourceDialect;
        this.targetDialect = targetDialect;
        this.preferenceStore = preferenceStore;
        this.syntaxManager = new SQLSyntaxManager();
        this.syntaxManager.init(targetDialect, preferenceStore);
    }

    @NotNull
    public SQLDialect getSourceDialect() {
        return this.sourceDialect;
    }

    @NotNull
    public SQLDialect getTargetDialect() {
        return this.targetDialect;
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    List<? extends SQLScriptElement> translateCommand(@NotNull SQLScriptElement element) throws DBException {
        if (element instanceof SQLQuery) {
            return this.translateQuery((SQLQuery)element);
        }
        return Collections.singletonList(element);
    }

    private List<? extends SQLScriptElement> translateQuery(@NotNull SQLQuery query) throws DBException {
        Statement statement = query.getStatement();
        if (statement != null) {
            return this.translateStatement(query, statement);
        }
        return Collections.singletonList(query);
    }

    private List<? extends SQLScriptElement> translateStatement(@NotNull SQLQuery query, @NotNull Statement statement) throws DBException {
        ArrayList<SQLQuery> extraQueries;
        block21: {
            extraQueries = null;
            if (!(statement instanceof CreateTable)) break block21;
            boolean defChanged = false;
            CreateTable createTable = (CreateTable)statement;
            for (ColumnDefinition cd : createTable.getColumnDefinitions()) {
                String newDataType = null;
                switch (cd.getColDataType().getDataType().toUpperCase(Locale.ENGLISH)) {
                    case "CLOB": {
                        newDataType = "varchar";
                    }
                }
                if (newDataType != null) {
                    cd.getColDataType().setDataType(newDataType);
                    defChanged = true;
                }
                if (CommonUtils.isEmpty((Collection)cd.getColumnSpecs())) continue;
                for (String cSpec : new ArrayList(cd.getColumnSpecs())) {
                    switch (cSpec.toUpperCase(Locale.ENGLISH)) {
                        case "AUTO_INCREMENT": {
                            String sequenceName = String.valueOf(CommonUtils.escapeIdentifier((String)createTable.getTable().getName())) + "_" + CommonUtils.escapeIdentifier((String)cd.getColumnName());
                            cd.getColumnSpecs().remove(cSpec);
                            cd.getColumnSpecs().add("DEFAULT");
                            cd.getColumnSpecs().add("NEXTVAL('" + sequenceName + "')");
                            defChanged = true;
                            String createSeqQuery = "CREATE SEQUENCE " + sequenceName;
                            if (extraQueries == null) {
                                extraQueries = new ArrayList();
                            }
                            extraQueries.add(new SQLQuery(null, createSeqQuery));
                        }
                    }
                }
            }
            if (defChanged) {
                String newQueryText = SQLFormatUtils.formatSQL(null, this.syntaxManager, createTable.toString());
                query.setText(newQueryText);
                if (extraQueries == null) {
                    extraQueries = new ArrayList<SQLQuery>();
                }
                extraQueries.add(query);
            }
        }
        if (extraQueries == null) {
            return Collections.singletonList(query);
        }
        return extraQueries;
    }
}

