/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCURL;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class NewConnectionFromUrlDialog
extends BaseDialog {
    private static final int INPUT_DELAY_BEFORE_REFRESH = 300;
    private TreeViewer driverViewer;
    private CLabel errorLabel;
    private String url;
    private DBPDriver driver;

    public NewConnectionFromUrlDialog(@NotNull Shell shell) {
        super(shell, CoreMessages.dialog_connection_from_url_title, null);
        this.setShellStyle(2160);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite parentComposite = super.createDialogArea(parent);
        Composite composite = UIUtils.createComposite((Composite)parentComposite, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        ((GridData)composite.getLayoutData()).widthHint = 500;
        final Text urlText = UIUtils.createLabelText((Composite)composite, (String)CoreMessages.dialog_connection_from_url_url, null);
        urlText.setMessage("jdbc:postgresql://localhost:5432/dbeaver");
        UIUtils.createControlLabel((Composite)composite, (String)CoreMessages.dialog_connection_from_url_drivers);
        this.driverViewer = new TreeViewer(composite, 2820);
        this.driverViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.driverViewer.setContentProvider((IContentProvider)new DriverContentProvider());
        this.driverViewer.setLabelProvider((IBaseLabelProvider)new DriverLabelProvider());
        this.driverViewer.addSelectionChangedListener(event -> {
            Object element = event.getStructuredSelection().getFirstElement();
            if (element instanceof DBPDriver) {
                this.driver = (DBPDriver)element;
            }
            this.updateCompletion();
        });
        this.errorLabel = new CLabel(composite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.errorLabel.setVisible(false);
        AbstractJob refreshJob = new AbstractJob("Refresh suitable drivers timeout"){

            protected IStatus run(DBRProgressMonitor monitor) {
                UIUtils.asyncExec(() -> {
                    List<Map.Entry<DBPDataSourceProviderDescriptor, List<DBPDriver>>> drivers = NewConnectionFromUrlDialog.this.getSuitableDrivers(urlText.getText());
                    NewConnectionFromUrlDialog.this.url = urlText.getText();
                    NewConnectionFromUrlDialog.this.driverViewer.getTree().setRedraw(false);
                    NewConnectionFromUrlDialog.this.driverViewer.setInput(drivers);
                    NewConnectionFromUrlDialog.this.driverViewer.expandAll();
                    NewConnectionFromUrlDialog.this.driverViewer.getTree().setRedraw(true);
                    if (!drivers.isEmpty()) {
                        NewConnectionFromUrlDialog.this.driverViewer.setSelection((ISelection)new StructuredSelection((Object)drivers.get(0).getValue().get(0)));
                    }
                    NewConnectionFromUrlDialog.this.updateCompletion();
                });
                return Status.OK_STATUS;
            }
        };
        refreshJob.setSystem(true);
        refreshJob.setUser(false);
        urlText.addModifyListener(event -> {
            if (!refreshJob.isCanceled()) {
                refreshJob.cancel();
            }
            refreshJob.schedule(300L);
        });
        urlText.addDisposeListener(event -> {
            if (!refreshJob.isCanceled()) {
                refreshJob.cancel();
            }
        });
        return parentComposite;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateCompletion();
    }

    @NotNull
    public DBPDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public DBPConnectionConfiguration extractConnectionConfiguration() {
        String sampleUrl = Objects.requireNonNull(this.driver.getSampleURL());
        return JDBCURL.extractConfigurationFromUrl((String)sampleUrl, (String)this.url);
    }

    @NotNull
    private List<Map.Entry<DBPDataSourceProviderDescriptor, List<DBPDriver>>> getSuitableDrivers(@NotNull String url) {
        LinkedHashMap result = new LinkedHashMap();
        HashMap<DBPDataSourceProviderDescriptor, Integer> scores = new HashMap<DBPDataSourceProviderDescriptor, Integer>();
        for (DBPDataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getDataSourceProviders()) {
            ArrayList<DBPDriver> drivers = new ArrayList<DBPDriver>();
            for (DBPDriver driver : provider.getEnabledDrivers()) {
                if (CommonUtils.isEmpty((String)driver.getSampleURL()) || !JDBCURL.getPattern((String)driver.getSampleURL()).matcher(url).matches()) continue;
                drivers.add(driver);
                scores.put(provider, scores.computeIfAbsent(provider, x -> 0) + 1);
            }
            if (drivers.isEmpty()) continue;
            drivers.sort(Comparator.comparing(DBPDriver::getPromotedScore).thenComparing(DBPDriver::getFullName).reversed());
            result.put(provider, drivers);
        }
        return result.entrySet().stream().sorted(Comparator.comparing(x -> (Integer)scores.get(x.getKey()), Comparator.reverseOrder())).collect(Collectors.toList());
    }

    private void updateCompletion() {
        if (this.driverViewer.getTree().getItemCount() == 0) {
            this.setCompleted(false, CoreMessages.dialog_connection_from_url_error_no_drivers_found);
            return;
        }
        if (!(this.driverViewer.getStructuredSelection().getFirstElement() instanceof DBPDriver)) {
            this.setCompleted(false, CoreMessages.dialog_connection_from_url_error_no_driver_selected);
            return;
        }
        this.setCompleted(true, "");
    }

    private void setCompleted(boolean valid, @NotNull String message) {
        this.getButton(0).setEnabled(valid);
        this.errorLabel.setVisible(!valid && CommonUtils.isNotEmpty((String)message));
        this.errorLabel.setText(message);
    }

    private static class DriverContentProvider
    extends TreeContentProvider {
        private DriverContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                return ((List)entry.getValue()).toArray();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Map.Entry;
        }
    }

    private static class DriverLabelProvider
    extends LabelProvider {
        private DriverLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                return ((DBPDataSourceProviderDescriptor)entry.getKey()).getName();
            }
            if (element instanceof DBPDriver) {
                return ((DBPDriver)element).getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                return DBeaverIcons.getImage((DBPImage)((DBPDataSourceProviderDescriptor)entry.getKey()).getIcon());
            }
            if (element instanceof DBPDriver) {
                return DBeaverIcons.getImage((DBPImage)((DBPDriver)element).getIcon());
            }
            return null;
        }
    }
}

