/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPForeignObject;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.search.AbstractSearchResult;
import org.jkiss.dbeaver.ui.search.data.SearchDataObject;
import org.jkiss.dbeaver.ui.search.data.SearchDataParams;
import org.jkiss.dbeaver.ui.search.data.SearchDataResult;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SearchDataQuery
implements ISearchQuery {
    private static final Log log = Log.getLog(SearchDataQuery.class);
    private final SearchDataParams params;
    private SearchDataResult searchResult;

    private SearchDataQuery(SearchDataParams params) {
        this.params = params;
    }

    public String getLabel() {
        return this.params.getSearchString();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new SearchDataResult(this);
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor m) throws OperationCanceledException {
        try {
            String searchString = this.params.getSearchString();
            HashSet<DBPDataSource> dataSources = new HashSet<DBPDataSource>();
            for (DBSDataContainer searcher : this.params.sources) {
                dataSources.add(searcher.getDataSource());
            }
            DBNModel dbnModel = DBWorkbench.getPlatform().getNavigatorModel();
            DefaultProgressMonitor monitor = new DefaultProgressMonitor(m);
            int totalObjects = 0;
            monitor.beginTask("Search \"" + searchString + "\" in " + this.params.sources.size() + " table(s) / " + dataSources.size() + " database(s)", this.params.sources.size());
            try {
                for (DBSDataContainer dataContainer : this.params.sources) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    if (this.searchDataInContainer((DBRProgressMonitor)monitor, dbnModel, dataContainer)) {
                        ++totalObjects;
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
            this.searchResult.fireChange(new AbstractSearchResult.DatabaseSearchFinishEvent(this.searchResult, totalObjects));
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return GeneralUtils.makeExceptionStatus((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchDataInContainer(DBRProgressMonitor monitor, DBNModel dbnModel, DBSDataContainer dataContainer) {
        if (!this.params.searchForeignObjects && dataContainer instanceof DBPForeignObject && ((DBPForeignObject)dataContainer).isForeignObject()) {
            return false;
        }
        String objectName = DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.DML);
        DBNDatabaseNode node = dbnModel.findNode((DBSObject)dataContainer);
        if (node == null) {
            log.warn((Object)("Can't find tree node for object \"" + objectName + "\""));
            return false;
        }
        monitor.subTask("Search in '" + objectName + "'");
        log.debug((Object)("Search in '" + objectName + "'"));
        SearchTableMonitor searchMonitor = new SearchTableMonitor(monitor);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)searchMonitor, (DBSObject)dataContainer, (String)("Search rows in " + objectName));){
                TestDataReceiver dataReceiver = new TestDataReceiver(searchMonitor);
                try {
                    this.findRows(session, dataContainer, dataReceiver);
                }
                catch (DBCException e) {
                    log.debug((Object)("Fulltext search failed in '" + dataContainer.getName() + "'"), (Throwable)e);
                }
                if (dataReceiver.rowCount <= 0) return false;
                SearchDataObject object = new SearchDataObject((DBNNode)node, dataReceiver.rowCount, dataReceiver.filter);
                this.searchResult.addObjects(Collections.singletonList(object));
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (DBCException e) {
            log.error((Object)"Error searching data in container", (Throwable)e);
        }
        return false;
    }

    private DBCStatistics findRows(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull TestDataReceiver dataReceiver) throws DBCException {
        ArrayList<DBDAttributeConstraint> constraints;
        block23: {
            if (!(dataContainer instanceof DBSEntity)) {
                log.warn((Object)("Data container " + dataContainer + " isn't entity"));
                return null;
            }
            DBSEntity entity = (DBSEntity)dataContainer;
            try {
                constraints = new ArrayList<DBDAttributeConstraint>();
                block19: for (DBSEntityAttribute attribute : CommonUtils.safeCollection((Collection)entity.getAttributes(session.getProgressMonitor()))) {
                    Object value;
                    DBCLogicalOperator operator;
                    if (this.params.fastSearch && DBUtils.findAttributeIndex((DBRProgressMonitor)session.getProgressMonitor(), (DBSEntityAttribute)attribute) == null || DBUtils.isPseudoAttribute((DBSAttributeBase)attribute) || DBUtils.isHiddenObject((Object)attribute)) continue;
                    Object[] supportedOperators = DBUtils.getAttributeOperators((DBSTypedObject)attribute);
                    switch (attribute.getDataKind()) {
                        case BOOLEAN: {
                            continue block19;
                        }
                        case NUMERIC: {
                            if (!this.params.searchNumbers || !ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.EQUALS)) continue block19;
                            operator = DBCLogicalOperator.EQUALS;
                            try {
                                value = Integer.valueOf(this.params.searchString);
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    value = Long.valueOf(this.params.searchString);
                                    break;
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    try {
                                        value = Double.valueOf(this.params.searchString);
                                        break;
                                    }
                                    catch (NumberFormatException numberFormatException3) {
                                        try {
                                            value = new BigDecimal(this.params.searchString);
                                            break;
                                        }
                                        catch (Exception exception) {
                                            continue block19;
                                        }
                                    }
                                }
                            }
                        }
                        case BINARY: 
                        case CONTENT: {
                            if (!this.params.searchLOBs) continue block19;
                        }
                        case STRING: {
                            if (!this.params.isCaseSensitive() && ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.ILIKE)) {
                                operator = DBCLogicalOperator.ILIKE;
                                value = "%" + this.params.searchString + "%";
                                break;
                            }
                            if (ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.LIKE)) {
                                operator = DBCLogicalOperator.LIKE;
                                value = "%" + this.params.searchString + "%";
                                break;
                            }
                            if (!ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.EQUALS)) continue block19;
                            operator = DBCLogicalOperator.EQUALS;
                            value = this.params.searchString;
                            break;
                        }
                        default: {
                            String typeName;
                            if (!ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.EQUALS) || !(typeName = attribute.getTypeName()).equals("UUID") && !typeName.equals(DBConstants.TYPE_NAME_UUID2)) continue block19;
                            try {
                                UUID uuid = UUID.fromString(this.params.searchString);
                                operator = DBCLogicalOperator.EQUALS;
                                value = uuid.toString();
                                break;
                            }
                            catch (Exception exception) {
                                continue block19;
                            }
                        }
                    }
                    DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)attribute, constraints.size());
                    constraint.setOperator(operator);
                    constraint.setValue(value);
                    constraint.setVisible(true);
                    constraints.add(constraint);
                }
                if (!constraints.isEmpty()) break block23;
                return null;
            }
            catch (DBException e) {
                throw new DBCException("Error finding rows", (Throwable)e);
            }
        }
        dataReceiver.filter = new DBDDataFilter(constraints);
        dataReceiver.filter.setAnyConstraint(true);
        AbstractExecutionSource searchSource = new AbstractExecutionSource(dataContainer, session.getExecutionContext(), (Object)this);
        return dataContainer.readData((DBCExecutionSource)searchSource, session, (DBDDataReceiver)dataReceiver, dataReceiver.filter, -1L, -1L, 0L, 0);
    }

    public static SearchDataQuery createQuery(SearchDataParams params) throws DBException {
        return new SearchDataQuery(params);
    }

    private class SearchTableMonitor
    extends VoidProgressMonitor {
        private DBRProgressMonitor baseMonitor;
        private volatile boolean canceled;

        private SearchTableMonitor(DBRProgressMonitor monitor) {
            this.baseMonitor = monitor;
        }

        public boolean isCanceled() {
            return this.canceled || this.baseMonitor.isCanceled();
        }
    }

    private class TestDataReceiver
    implements DBDDataReceiver {
        private SearchTableMonitor searchMonitor;
        private int rowCount = 0;
        private DBDDataFilter filter;

        TestDataReceiver(SearchTableMonitor searchMonitor) {
            this.searchMonitor = searchMonitor;
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
            ++this.rowCount;
            if (this.rowCount >= SearchDataQuery.this.params.maxResults) {
                this.searchMonitor.canceled = true;
            }
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void close() {
        }
    }
}

