/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SQLParserContext {
    @Nullable
    private final DBPDataSource dataSource;
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final SQLRuleManager ruleManager;
    @NotNull
    private final IDocument document;
    private TPRuleBasedScanner scanner;

    public SQLParserContext(@Nullable DBPDataSource dataSource, @NotNull SQLSyntaxManager syntaxManager, @NotNull SQLRuleManager ruleManager, @NotNull IDocument document) {
        this.dataSource = dataSource;
        this.syntaxManager = syntaxManager;
        this.ruleManager = ruleManager;
        this.document = document;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    @NotNull
    public SQLRuleManager getRuleManager() {
        return this.ruleManager;
    }

    @NotNull
    public IDocument getDocument() {
        return this.document;
    }

    public SQLDialect getDialect() {
        return SQLUtils.getDialectFromDataSource((DBPDataSource)this.getDataSource());
    }

    public TPRuleBasedScanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new TPRuleBasedScanner();
            this.scanner.setRules(this.ruleManager.getAllRules());
        }
        return this.scanner;
    }

    public DBPPreferenceStore getPreferenceStore() {
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? DBWorkbench.getPlatform().getPreferenceStore() : dataSource.getContainer().getPreferenceStore();
    }

    void startScriptEvaluation() {
        this.getScanner().startEval();
    }

    void endScriptEvaluation() {
        this.getScanner().endEval();
    }
}

