/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLMultiWordRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLVariableRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.utils.CommonUtils;

public class SQLServerDialect
extends JDBCSQLDialect
implements TPRuleProvider {
    private static final String[][] TSQL_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}};
    private static String[] SQLSERVER_EXTRA_KEYWORDS = new String[]{"LOGIN", "TOP", "SYNONYM", "PERSISTED"};
    private static final String[][] SQLSERVER_QUOTE_STRINGS = new String[][]{{"[", "]"}, {"\"", "\""}};
    private static final String[][] SYBASE_LEGACY_QUOTE_STRINGS = new String[][]{{"\"", "\""}};
    private static String[] EXEC_KEYWORDS = new String[]{"CALL", "EXEC", "EXECUTE"};
    private static String[] PLAIN_TYPE_NAMES = new String[]{"geography", "geometry", "timestamp", "image"};
    private static String[] SQLSERVER_FUNCTIONS_DATETIME = new String[]{"CURRENT_TIMEZONE", "DATEPART", "DATEADD", "DATEDIFF", "DATEDIFF_BIG", "DATEFROMPARTS", "DATENAME", "DATETIMEFROMPARTS", "EOMONTH", "GETDATE", "GETUTCDATE", "ISDATE", "SYSDATETIMEOFFSET", "SYSUTCDATETIME", "SMALLDATETIMEFROMPARTS", "SWITCHOFFSET", "TIMEFROMPARTS", "TODATETIMEOFFSET"};
    private JDBCDataSource dataSource;
    private boolean isSqlServer;

    public SQLServerDialect() {
        super("SQLServer", "sqlserver");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        super.addSQLKeywords(Arrays.asList(SQLSERVER_EXTRA_KEYWORDS));
        this.dataSource = dataSource;
        this.isSqlServer = SQLServerUtils.isDriverSqlServer(dataSource.getContainer().getDriver());
        this.addFunctions(Arrays.asList(SQLSERVER_FUNCTIONS_DATETIME));
    }

    @NotNull
    public String[] getScriptDelimiters() {
        return new String[]{";", "GO"};
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || this.validCharacters.indexOf(c) != -1;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @NotNull
    public String[] getParametersPrefixes() {
        return super.getParametersPrefixes();
    }

    public boolean isDelimiterAfterQuery() {
        return this.isSqlServer;
    }

    public boolean needsDelimiterFor(String firstKeyword, String lastKeyword) {
        return "MERGE".equalsIgnoreCase(firstKeyword) && lastKeyword != null;
    }

    public boolean supportsSubqueries() {
        return true;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsNestedComments() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        if (this.dataSource == null || !this.isSqlServer && !this.dataSource.isServerVersionAtLeast(12, 6)) {
            return SYBASE_LEGACY_QUOTE_STRINGS;
        }
        return SQLSERVER_QUOTE_STRINGS;
    }

    public String[][] getBlockBoundStrings() {
        return TSQL_BEGIN_END_BLOCK;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        if (this.isSqlServer) {
            if (this.dataSource.isServerVersionAtLeast(10, 0)) {
                return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
            }
            return super.getDefaultMultiValueInsertMode();
        }
        return super.getDefaultMultiValueInsertMode();
    }

    /*
     * Exception decompiling
     */
    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl71 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl71 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters) {
        ArrayList inParameters = new ArrayList();
        int maxParamLength = this.getMaxParameterLength(parameters, inParameters);
        String schemaName = proc.getContainer().getParentObject().getName();
        sql.append("USE [").append(schemaName).append("]\n");
        sql.append("GO\n\n");
        sql.append("DECLARE\t@return_value int\n\n");
        sql.append("EXEC\t@return_value = [").append(proc.getContainer().getName()).append("].[").append(proc.getName()).append("]\n");
        int i = 0;
        while (i < inParameters.size()) {
            String name = ((DBSProcedureParameter)inParameters.get(i)).getName();
            sql.append("\t\t").append(name).append(" = :").append(CommonUtils.escapeIdentifier((String)name));
            if (i < inParameters.size() - 1) {
                sql.append(", ");
            } else {
                sql.append(" ");
            }
            int width = maxParamLength + 70 - name.length() / 2;
            String typeName = ((DBSProcedureParameter)inParameters.get(i)).getParameterType().getFullTypeName();
            sql.append(CommonUtils.fixedLengthString((String)("-- put the " + name + " parameter value instead of '?' (" + typeName + ")\n"), (int)width));
            ++i;
        }
        sql.append("\nSELECT\t'Return Value' = @return_value\n\n");
        sql.append("GO\n\n");
    }

    public boolean isQuotedString(String string) {
        if (string.length() >= 3 && string.charAt(0) == 'N') {
            return super.isQuotedString(string.substring(1));
        }
        return super.isQuotedString(string);
    }

    public String getQuotedString(String string) {
        return String.valueOf('N') + super.getQuotedString(string);
    }

    public String getUnquotedString(String string) {
        if (string.length() >= 3 && string.charAt(0) == 'N') {
            return super.getUnquotedString(string.substring(1));
        }
        return super.getUnquotedString(string);
    }

    @NotNull
    protected String quoteIdentifier(@NotNull String str, @NotNull String[][] quoteStrings) {
        return String.valueOf('[') + str.replace("]", "]]") + ']';
    }

    public boolean isWordStart(int ch) {
        return super.isWordStart(ch) || ch == 35;
    }

    public boolean isWordPart(int ch) {
        return super.isWordPart(ch) || ch == 35;
    }

    public String[] getSingleLineComments() {
        if (!this.isSqlServer) {
            return new String[]{"--", "//"};
        }
        return super.getSingleLineComments();
    }

    public void extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull List<TPRule> rules, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.FINAL) {
            rules.add((TPRule)new SQLVariableRule((SQLDialect)this));
        }
        if (position == TPRuleProvider.RulePosition.KEYWORDS) {
            TPTokenDefault keywordToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_KEYWORD);
            rules.add((TPRule)new SQLMultiWordRule(new String[]{"BEGIN", "DISTRIBUTED", "TRANSACTION"}, (TPToken)keywordToken));
            rules.add((TPRule)new SQLMultiWordRule(new String[]{"BEGIN", "DISTRIBUTED", "TRAN"}, (TPToken)keywordToken));
            rules.add((TPRule)new SQLMultiWordRule(new String[]{"BEGIN", "TRANSACTION"}, (TPToken)keywordToken));
            rules.add((TPRule)new SQLMultiWordRule(new String[]{"BEGIN", "TRAN"}, (TPToken)keywordToken));
        }
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return this.isSqlServer;
    }
}

