/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.utils.CommonUtils;

public class PostgreToolTableTruncateSettings
extends SQLToolExecuteSettings<PostgreTableBase> {
    private boolean isRunning;
    private boolean isOnly;
    private boolean isRestarting;
    private boolean isCascading;

    @Property(viewable=true, editable=true, updatable=true)
    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreSupportTruncateOptionOnlyValidator.class)
    public boolean isOnly() {
        return this.isOnly;
    }

    public void setOnly(boolean only) {
        this.isOnly = only;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreSupportTruncateOptionIdentityValidator.class)
    public boolean isRestarting() {
        return this.isRestarting;
    }

    public void setRestarting(boolean restarting) {
        this.isRestarting = restarting;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreSupportTruncateOptionCascadeValidator.class)
    public boolean isCascading() {
        return this.isCascading;
    }

    public void setCascading(boolean cascading) {
        this.isCascading = cascading;
    }

    public void loadConfiguration(DBRRunnableContext runnableContext, Map<String, Object> config) {
        super.loadConfiguration(runnableContext, config);
        this.isRunning = JSONUtils.getBoolean(config, (String)"run_in_separate_transaction");
        this.isOnly = JSONUtils.getBoolean(config, (String)"only");
        this.isRestarting = JSONUtils.getBoolean(config, (String)"restart_identity");
        this.isCascading = JSONUtils.getBoolean(config, (String)"cascade");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("run_in_separate_transaction", this.isRunning());
        config.put("only", this.isOnly);
        config.put("restart_identity", this.isRestarting);
        config.put("cascade", this.isCascading);
    }

    private static boolean isTruncateModeSupported(PostgreToolTableTruncateSettings settings, int mode) {
        List tablesList = settings.getObjectList();
        if (!CommonUtils.isEmpty((Collection)tablesList)) {
            PostgreTableBase tableBase = (PostgreTableBase)tablesList.get(0);
            return CommonUtils.isBitSet((int)((PostgreDataSource)tableBase.getDataSource()).getServerType().getTruncateToolModes(), (int)mode);
        }
        return false;
    }

    public static class PostgreSupportTruncateOptionCascadeValidator
    implements IPropertyValueValidator<PostgreToolTableTruncateSettings, Object> {
        public boolean isValidValue(PostgreToolTableTruncateSettings settings, Object value) throws IllegalArgumentException {
            return PostgreToolTableTruncateSettings.isTruncateModeSupported(settings, 4);
        }
    }

    public static class PostgreSupportTruncateOptionIdentityValidator
    implements IPropertyValueValidator<PostgreToolTableTruncateSettings, Object> {
        public boolean isValidValue(PostgreToolTableTruncateSettings settings, Object value) throws IllegalArgumentException {
            return PostgreToolTableTruncateSettings.isTruncateModeSupported(settings, 2);
        }
    }

    public static class PostgreSupportTruncateOptionOnlyValidator
    implements IPropertyValueValidator<PostgreToolTableTruncateSettings, Object> {
        public boolean isValidValue(PostgreToolTableTruncateSettings settings, Object value) throws IllegalArgumentException {
            return PostgreToolTableTruncateSettings.isTruncateModeSupported(settings, 1);
        }
    }
}

