/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExecutionContext;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class PostgreStructureAssistant
implements DBSStructureAssistant<PostgreExecutionContext> {
    private static final Log log = Log.getLog(PostgreStructureAssistant.class);
    private final PostgreDataSource dataSource;

    public PostgreStructureAssistant(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_DATA_TYPE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN};
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull PostgreExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        PostgreDatabase database;
        DBSObject parentObject = params.getParentObject();
        PostgreSchema ownerSchema = parentObject instanceof PostgreSchema ? (PostgreSchema)parentObject : null;
        PostgreDataSource dataSource = executionContext.getDataSource();
        PostgreDatabase postgreDatabase = database = parentObject instanceof PostgreObject ? ((PostgreObject)parentObject).getDatabase() : executionContext.getDefaultCatalog();
        if (database == null) {
            database = dataSource.getDefaultInstance();
        }
        ArrayList<PostgreSchema> nsList = new ArrayList<PostgreSchema>();
        if (ownerSchema != null) {
            nsList.add(0, ownerSchema);
        } else if (!params.isGlobalSearch()) {
            for (String sn : executionContext.getSearchPath()) {
                PostgreSchema schema = database.getSchema(monitor, PostgreUtils.getRealSchemaName(database, sn));
                if (schema == null) continue;
                nsList.add(schema);
            }
            PostgreSchema pgCatalog = database.getCatalogSchema(monitor);
            if (pgCatalog != null) {
                nsList.add(pgCatalog);
            }
        } else {
            DBSObjectFilter schemaFilter = dataSource.getContainer().getObjectFilter(PostgreSchema.class, (DBSObject)database, true);
            if (schemaFilter != null && schemaFilter.isEnabled()) {
                for (PostgreSchema postgreSchema : database.getSchemas(monitor)) {
                    if (!schemaFilter.matches(postgreSchema.getName())) continue;
                    nsList.add(postgreSchema);
                }
            }
        }
        if (executionContext.getDefaultCatalog() != database) {
            executionContext = database.getMetaContext();
        }
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        try {
            Throwable throwable = null;
            Iterator<PostgreSchema> iterator = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, ModelMessages.model_jdbc_find_objects_by_name);){
                DBSObjectType[] dBSObjectTypeArray = params.getObjectTypes();
                int n = dBSObjectTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectType type = dBSObjectTypeArray[n2];
                    if (type == RelationalObjectType.TYPE_TABLE) {
                        PostgreStructureAssistant.findTablesByMask(session, database, nsList, params, references);
                    } else if (type == RelationalObjectType.TYPE_CONSTRAINT) {
                        PostgreStructureAssistant.findConstraintsByMask(session, database, nsList, params, references);
                    } else if (type == RelationalObjectType.TYPE_PROCEDURE) {
                        PostgreStructureAssistant.findProceduresByMask(session, database, nsList, params, references);
                    } else if (type == RelationalObjectType.TYPE_TABLE_COLUMN) {
                        PostgreStructureAssistant.findTableColumnsByMask(session, database, nsList, params, references);
                    }
                    if (references.size() >= params.getMaxResults()) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                void var10_15;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var10_15;
            }
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException, (DBPDataSource)this.getDataSource());
        }
        return references;
    }

    private static void findTablesByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull List<PostgreSchema> schemas, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull Collection<? super DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("pc.oid,pc.relname,pc.relnamespace,pc.relkind", "pg_catalog.pg_class pc", "pc.relname", schemas, "pc.relnamespace", "pc.relname");
        queryParams.setWhereClause("pc.relkind in('r','v','m','f','p')");
        queryParams.setCaseSensitive(params.isCaseSensitive());
        if (params.isSearchInComments()) {
            queryParams.setDescriptionClause("obj_description(pc.oid, 'pg_class')");
        }
        if (params.isSearchInDefinitions()) {
            queryParams.setDefinitionClause("pc.relkind = 'v' AND pg_get_viewdef(pc.\"oid\")");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        String sql = PostgreStructureAssistant.buildFindQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schemas, params.isSearchInDefinitions());
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                    final long tableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                    PostgreClass.RelKind tableType = PostgreClass.RelKind.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind"));
                    final PostgreSchema tableSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (tableSchema == null) {
                        log.debug((Object)("Can't resolve table '" + tableName + "' - owner schema " + schemaId + " not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(tableName, tableSchema, null, tableType == PostgreClass.RelKind.r ? PostgreTable.class : (tableType == PostgreClass.RelKind.v ? PostgreView.class : PostgreMaterializedView.class), RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableBase table = tableSchema.getTable(monitor, tableId);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in schema '" + tableSchema.getName() + "'");
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void findProceduresByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull List<PostgreSchema> schemas, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull Collection<? super DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        PostgreServerExtension serverType = database.getDataSource().getServerType();
        QueryParams queryParams = new QueryParams("pp." + serverType.getProceduresOidColumn() + " as poid, pp.*", "pg_catalog." + serverType.getProceduresSystemTable() + " pp", "pp.proname", schemas, "pp.pronamespace", "pp.proname");
        queryParams.setCaseSensitive(params.isCaseSensitive());
        if (params.isSearchInComments()) {
            queryParams.setDescriptionClause("obj_description(pp.oid, 'pg_proc')");
        }
        if (params.isSearchInDefinitions()) {
            queryParams.setDefinitionClause("pp.prokind <> 'm' AND pp.prokind <> 'a' AND pg_get_functiondef(pp.\"oid\")");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        String sql = PostgreStructureAssistant.buildFindQuery(queryParams);
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schemas, params.isSearchInDefinitions());
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"pronamespace");
                    final String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname");
                    final long procId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"poid");
                    final PostgreSchema procSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (procSchema == null) {
                        log.debug((Object)("Procedure's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    PostgreProcedure proc = new PostgreProcedure(monitor, procSchema, (ResultSet)dbResult);
                    objects.add((DBSObjectReference)new AbstractObjectReference(procName, procSchema, null, PostgreProcedure.class, RelationalObjectType.TYPE_PROCEDURE, String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)procSchema)) + "." + proc.getOverloadedName()){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreProcedure procedure = procSchema.getProcedure(monitor, procId);
                            if (procedure == null) {
                                throw new DBException("Procedure '" + procName + "' not found in schema '" + procSchema.getName() + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void findConstraintsByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull List<PostgreSchema> schemas, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull Collection<? super DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("pc.oid, pc.conname, pc.connamespace", "pg_catalog.pg_constraint pc", "pc.conname", schemas, "pc.connamespace", "pc.conname");
        queryParams.setCaseSensitive(params.isCaseSensitive());
        if (params.isSearchInComments()) {
            queryParams.setDescriptionClause("obj_description(pc.oid, 'pg_constraint')");
        }
        if (params.isSearchInDefinitions()) {
            queryParams.setDefinitionClause("pg_get_constraintdef(pc.\"oid\")");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        String sql = PostgreStructureAssistant.buildFindQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schemas, params.isSearchInDefinitions());
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"connamespace");
                    final long constrId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"conname");
                    final PostgreSchema constrSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (constrSchema == null) {
                        log.debug((Object)("Constraint's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, constrSchema, null, PostgreTableConstraintBase.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableConstraintBase constraint = (PostgreTableConstraintBase)PostgreUtils.getObjectById(monitor, constrSchema.getConstraintCache(), constrSchema, constrId);
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in schema '" + constrSchema.getName() + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void findTableColumnsByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull List<PostgreSchema> schemas, @NotNull DBSStructureAssistant.ObjectsSearchParams objectsSearchParams, @NotNull Collection<? super DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("x.attname,x.attrelid,x.atttypid,c.relnamespace", "pg_catalog.pg_attribute x, pg_catalog.pg_class c", "x.attname", schemas, "c.relnamespace", "x.attname");
        queryParams.setWhereClause("c.oid=x.attrelid");
        if (objectsSearchParams.isSearchInComments()) {
            queryParams.setDescriptionClause("col_description(c.oid, x.attnum)");
        }
        queryParams.setMaxResults(objectsSearchParams.getMaxResults() - objects.size());
        queryParams.setCaseSensitive(objectsSearchParams.isCaseSensitive());
        String sql = PostgreStructureAssistant.buildFindQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, objectsSearchParams, schemas, false);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                    final long tableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"attrelid");
                    final String attributeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attname");
                    final PostgreSchema constrSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (constrSchema == null) {
                        log.debug((Object)("Attribute's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(attributeName, constrSchema, null, PostgreTableBase.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableBase table = (PostgreTableBase)PostgreUtils.getObjectById(monitor, constrSchema.getTableCache(), constrSchema, tableId);
                            if (table == null) {
                                throw new DBException("Table '" + tableId + "' not found in schema '" + constrSchema.getName() + "'");
                            }
                            return table.getAttribute(monitor, attributeName);
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String buildFindQuery(@NotNull QueryParams queryParams) {
        boolean addParentheses;
        StringBuilder sql = new StringBuilder("SELECT ").append(queryParams.getColumnsToSelect());
        sql.append(" FROM ").append(queryParams.getFromClause()).append(" WHERE ");
        if (queryParams.getWhereClause() != null) {
            sql.append(queryParams.getWhereClause()).append(" AND ");
        }
        boolean bl = addParentheses = queryParams.getDefinitionClause() != null || queryParams.getDescriptionClause() != null;
        if (addParentheses) {
            sql.append("(");
        }
        String likeClause = queryParams.isCaseSensitive() ? " LIKE ?" : " ILIKE ?";
        sql.append(queryParams.getName()).append(likeClause).append(" ");
        if (queryParams.getDescriptionClause() != null) {
            sql.append("OR ").append(queryParams.getDescriptionClause()).append(likeClause);
        }
        if (queryParams.getDefinitionClause() != null) {
            sql.append(" OR (").append(queryParams.getDefinitionClause()).append(likeClause).append(")");
        }
        if (addParentheses) {
            sql.append(")");
        }
        if (!queryParams.getSchemas().isEmpty()) {
            sql.append("AND ").append(queryParams.getNamespace()).append(" IN (");
            sql.append(SQLUtils.generateParamList((int)queryParams.getSchemas().size())).append(") ");
        }
        sql.append("ORDER BY ").append(queryParams.getOrderBy()).append(" LIMIT ").append(queryParams.getMaxResults());
        return sql.toString();
    }

    private static void fillParams(@NotNull JDBCPreparedStatement statement, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @Nullable List<? extends PostgreSchema> schema, boolean fillSearchInDefinitions) throws SQLException {
        statement.setString(1, params.getMask());
        int idx = 2;
        if (params.isSearchInComments()) {
            statement.setString(idx, params.getMask());
            ++idx;
        }
        if (fillSearchInDefinitions) {
            statement.setString(idx, params.getMask());
            ++idx;
        }
        if (!CommonUtils.isEmpty(schema)) {
            PostgreUtils.setArrayParameter(statement, idx, schema);
        }
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType == RelationalObjectType.TYPE_TABLE || objectType == RelationalObjectType.TYPE_CONSTRAINT || objectType == RelationalObjectType.TYPE_PROCEDURE || objectType == RelationalObjectType.TYPE_TABLE_COLUMN;
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return objectType == RelationalObjectType.TYPE_CONSTRAINT || objectType == RelationalObjectType.TYPE_PROCEDURE;
    }

    private static final class QueryParams {
        @NotNull
        private final String columnsToSelect;
        @NotNull
        private final String fromClause;
        @Nullable
        private String whereClause;
        @NotNull
        private final String name;
        private boolean caseSensitive;
        @Nullable
        private String descriptionClause;
        @NotNull
        private final Collection<? extends PostgreSchema> schemas;
        @NotNull
        private final String namespace;
        @NotNull
        private final String orderBy;
        private int maxResults;
        @Nullable
        private String definitionClause;

        private QueryParams(@NotNull String columnsToSelect, @NotNull String fromClause, @NotNull String name, @NotNull Collection<? extends PostgreSchema> schemas, @NotNull String namespace, @NotNull String orderBy) {
            this.columnsToSelect = columnsToSelect;
            this.fromClause = fromClause;
            this.name = name;
            this.schemas = schemas;
            this.namespace = namespace;
            this.orderBy = orderBy;
        }

        @NotNull
        private String getColumnsToSelect() {
            return this.columnsToSelect;
        }

        @NotNull
        private String getFromClause() {
            return this.fromClause;
        }

        @Nullable
        private String getWhereClause() {
            return this.whereClause;
        }

        private void setWhereClause(@Nullable String whereClause) {
            this.whereClause = whereClause;
        }

        @NotNull
        private String getName() {
            return this.name;
        }

        private boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        private void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Nullable
        private String getDescriptionClause() {
            return this.descriptionClause;
        }

        private void setDescriptionClause(@Nullable String descriptionClause) {
            this.descriptionClause = descriptionClause;
        }

        @NotNull
        private Collection<PostgreSchema> getSchemas() {
            return Collections.unmodifiableCollection(this.schemas);
        }

        @NotNull
        private String getNamespace() {
            return this.namespace;
        }

        @NotNull
        private String getOrderBy() {
            return this.orderBy;
        }

        private int getMaxResults() {
            return this.maxResults;
        }

        private void setMaxResults(int maxResults) {
            this.maxResults = maxResults;
        }

        @Nullable
        private String getDefinitionClause() {
            return this.definitionClause;
        }

        private void setDefinitionClause(@Nullable String definitionClause) {
            this.definitionClause = definitionClause;
        }
    }
}

