/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.hana.model.HANATableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexString;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLVariableRule;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.utils.CommonUtils;

public class HANASQLDialect
extends GenericSQLDialect
implements TPRuleProvider {
    private static final Log log = Log.getLog(HANASQLDialect.class);
    private static final String[][] HANA_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"IF", "END"}, {"CASE", "END"}, {"FOR", "END FOR"}};

    public HANASQLDialect() {
        super("HANA", "sap_hana");
    }

    public String[][] getBlockBoundStrings() {
        return HANA_BEGIN_END_BLOCK;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList("REPLACE_REGEXPR"));
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public String getDualTableName() {
        return "DUMMY";
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        String ucTypeName = CommonUtils.notEmpty((String)typeName).toUpperCase(Locale.ENGLISH);
        if (("ST_POINT".equals(ucTypeName) || "ST_GEOMETRY".equals(ucTypeName)) && column instanceof HANATableColumn) {
            HANATableColumn hanaColumn = (HANATableColumn)column;
            try {
                int srid = hanaColumn.getAttributeGeometrySRID((DBRProgressMonitor)new VoidProgressMonitor());
                return "(" + Integer.toString(srid) + ")";
            }
            catch (DBCException e) {
                log.info((Object)"Could not determine SRID of column", (Throwable)e);
            }
        }
        return super.getColumnTypeModifiers(dataSource, column, ucTypeName, dataKind);
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexString.INSTANCE;
    }

    @NotNull
    public String getSearchStringEscape() {
        return "\\";
    }

    public void extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull List<TPRule> rules, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.FINAL) {
            rules.add((TPRule)new SQLVariableRule((SQLDialect)this));
        }
    }
}

