/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAvailableExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class PostgreCreateExtensionDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.PostgreCreateExtensionDialog";
    private PostgreAvailableExtension extension;
    private final PostgreExtension newextension;
    private List<PostgreSchema> allSchemas;
    private PostgreSchema schema;
    private TableViewer extTable;

    public PostgreCreateExtensionDialog(Shell parentShell, PostgreExtension extension) {
        super(parentShell, PostgreMessages.dialog_create_extension_title, null);
        this.newextension = extension;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    private void checkEnabled() {
        this.getButton(0).setEnabled(this.extension != null && this.schema != null);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 200;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        group.setLayoutData((Object)gd);
        UIUtils.createLabelText((Composite)group, (String)PostgreMessages.dialog_create_extension_database, (String)this.newextension.getDatabase().getName(), (int)2056);
        final Combo schemaCombo = UIUtils.createLabelCombo((Composite)group, (String)PostgreMessages.dialog_create_extension_schema, (int)2060);
        UIUtils.createLabel((Composite)group, (String)PostgreMessages.dialog_create_extension_name);
        this.extTable = new TableViewer(group, 68352);
        final Table table = this.extTable.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UIUtils.packColumns((Table)table);
                UIUtils.maxTableColumnsWidth((Table)table);
                table.removeControlListener((ControlListener)this);
            }
        });
        ViewerColumnController columnController = new ViewerColumnController("AvailabelExtensionDialog", (ColumnViewer)this.extTable);
        columnController.addColumn(PostgreMessages.dialog_create_extension_column_name, null, 0, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((PostgreAvailableExtension)cell.getElement()).getName());
            }
        });
        columnController.addColumn(PostgreMessages.dialog_create_extension_column_version, null, 0, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((PostgreAvailableExtension)cell.getElement()).getVersion());
            }
        });
        columnController.addColumn(PostgreMessages.dialog_create_extension_column_description, null, 0, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((PostgreAvailableExtension)cell.getElement()).getDescription());
            }
        });
        columnController.createColumns();
        this.extTable.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                this.extension = (PostgreAvailableExtension)selection.getFirstElement();
                this.checkEnabled();
            }
        });
        this.extTable.setContentProvider((IContentProvider)new ListContentProvider());
        schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateExtensionDialog.this.schema = PostgreCreateExtensionDialog.this.allSchemas.get(schemaCombo.getSelectionIndex());
                PostgreCreateExtensionDialog.this.checkEnabled();
            }
        });
        new AbstractJob("Load schemas"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    PostgreCreateExtensionDialog.this.allSchemas = new ArrayList<PostgreSchema>(PostgreCreateExtensionDialog.this.newextension.getDatabase().getSchemas(monitor));
                    UIUtils.syncExec(() -> {
                        for (PostgreSchema schema : PostgreCreateExtensionDialog.this.allSchemas) {
                            schemaCombo.add(schema.getName());
                        }
                        PostgreCreateExtensionDialog.this.schema = (PostgreSchema)DBUtils.findObject(PostgreCreateExtensionDialog.this.allSchemas, (String)"public");
                        if (PostgreCreateExtensionDialog.this.schema != null) {
                            schemaCombo.setText(PostgreCreateExtensionDialog.this.schema.getName());
                        }
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        new AbstractJob("Load available extensions"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    ArrayList installed = new ArrayList(PostgreCreateExtensionDialog.this.newextension.getDatabase().getAvailableExtensions(monitor));
                    UIUtils.syncExec(() -> PostgreCreateExtensionDialog.this.extTable.setInput((Object)installed));
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public PostgreAvailableExtension getExtension() {
        return this.extension;
    }

    public PostgreSchema getSchema() {
        return this.schema;
    }
}

