/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.properties;

import java.lang.reflect.Type;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.AdvancedTextCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomNumberCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomTextCellEditor;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class PropertyEditorUtils {
    private static final Log log = Log.getLog(PropertyEditorUtils.class);

    public static CellEditor createPropertyEditor(IServiceLocator serviceLocator, Composite parent, DBPPropertySource source, DBPPropertyDescriptor property, int style) {
        if (source == null) {
            return null;
        }
        Object object = source.getEditableValue();
        if (!property.isEditable(object)) {
            return null;
        }
        CellEditor cellEditor = PropertyEditorUtils.createCellEditor(parent, object, property, style);
        if (cellEditor != null) {
            Control editorControl = cellEditor.getControl();
            UIUtils.addDefaultEditActionsSupport(serviceLocator, editorControl);
        }
        return cellEditor;
    }

    public static CellEditor createCellEditor(Composite parent, Object object, DBPPropertyDescriptor property, int style) {
        Object editor;
        IPropertyValueListProvider listProvider;
        Object[] items;
        boolean isPropertySheet = (style & 0x10000000) != 0;
        style &= 0xEFFFFFFF;
        if (property instanceof IPropertyValueListProvider && (items = (listProvider = (IPropertyValueListProvider)property).getPossibleValues(object)) != null) {
            String[] strings = new String[items.length];
            int i = 0;
            int itemsLength = items.length;
            while (i < itemsLength) {
                strings[i] = items[i] instanceof DBPNamedObject ? ((DBPNamedObject)items[i]).getName() : CommonUtils.toString((Object)items[i]);
                ++i;
            }
            CustomComboBoxCellEditor editor2 = new CustomComboBoxCellEditor(parent, strings, 4 | (listProvider.allowCustomValue() ? 0 : 8));
            return editor2;
        }
        Class propertyType = property.getDataType();
        if (propertyType == null || CharSequence.class.isAssignableFrom(propertyType)) {
            if (property instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)property).getLength() == PropertyLength.MULTILINE) {
                editor = new AdvancedTextCellEditor(parent);
                PropertyEditorUtils.setValidator((CellEditor)editor, property, object);
                return editor;
            }
            editor = new CustomTextCellEditor(parent, 4 | ((style & 0x400000) != 0 ? 0x400000 : 0));
            PropertyEditorUtils.setValidator((CellEditor)editor, property, object);
            return editor;
        }
        if (BeanUtils.isNumericType((Class)propertyType)) {
            editor = new CustomNumberCellEditor(parent, propertyType);
            PropertyEditorUtils.setValidator((CellEditor)editor, property, object);
            return editor;
        }
        if (BeanUtils.isBooleanType((Type)propertyType)) {
            if (isPropertySheet) {
                return new CustomComboBoxCellEditor(parent, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}, 12);
            }
            return new CustomCheckboxCellEditor(parent);
        }
        if (propertyType.isEnum()) {
            T[] enumConstants = propertyType.getEnumConstants();
            String[] strings = new String[enumConstants.length];
            int i = 0;
            int itemsLength = enumConstants.length;
            while (i < itemsLength) {
                strings[i] = ((Enum)enumConstants[i]).name();
                ++i;
            }
            return new CustomComboBoxCellEditor(parent, strings, 12);
        }
        log.warn((Object)("Unsupported property type: " + propertyType.getName()));
        return null;
    }

    private static void setValidator(CellEditor editor, DBPPropertyDescriptor property, Object object) {
        IPropertyValueValidator valueValidator;
        if (property instanceof ObjectPropertyDescriptor && (valueValidator = ((ObjectPropertyDescriptor)property).getValueValidator()) != null) {
            editor.setValidator((ICellEditorValidator)new PropertyCellEditorValidator(valueValidator, object));
        }
    }

    private static class PropertyCellEditorValidator
    implements ICellEditorValidator {
        private final IPropertyValueValidator validator;
        private final Object object;

        PropertyCellEditorValidator(IPropertyValueValidator validator, Object object) {
            this.validator = validator;
            this.object = object;
        }

        public String isValid(Object value) {
            try {
                boolean validValue = this.validator.isValidValue(this.object, value);
                if (validValue) {
                    return null;
                }
                return "Invalid";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
    }
}

