/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.model;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.model.ERDContainerDecorated;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.model.ERDModelAdapter;
import org.jkiss.dbeaver.erd.ui.model.ERDModelAdapterDefault;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;

public class EntityDiagram
extends ERDDiagram
implements ERDContainerDecorated {
    private static final Log log = Log.getLog(EntityDiagram.class);
    private ERDModelAdapter modelAdapter;
    private ERDDecorator decorator;
    private boolean layoutManualDesired = true;
    private boolean layoutManualAllowed = false;
    private boolean needsAutoLayout;
    private final Map<ERDNote, ERDContainerDecorated.NodeVisualInfo> noteVisuals = new IdentityHashMap<ERDNote, ERDContainerDecorated.NodeVisualInfo>();
    private final Map<DBSEntity, ERDContainerDecorated.NodeVisualInfo> entityVisuals = new IdentityHashMap<DBSEntity, ERDContainerDecorated.NodeVisualInfo>();
    private ERDAttributeVisibility attributeVisibility;
    private ERDViewStyle[] attributeStyles;

    public EntityDiagram(DBSObject container, String name, ERDContentProvider contentProvider, ERDDecorator decorator) {
        super(container, name, contentProvider);
        this.modelAdapter = (ERDModelAdapter)RuntimeUtils.getObjectAdapter((Object)this, ERDModelAdapter.class, (boolean)true);
        if (this.modelAdapter == null) {
            this.modelAdapter = new ERDModelAdapterDefault();
        }
        this.decorator = decorator;
        DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
        this.attributeVisibility = ERDAttributeVisibility.getDefaultVisibility((DBPPreferenceStore)store);
        this.attributeStyles = ERDViewStyle.getDefaultStyles(store);
    }

    @NotNull
    public ERDModelAdapter getModelAdapter() {
        return this.modelAdapter;
    }

    @Override
    @NotNull
    public ERDDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public boolean hasAttributeStyle(@NotNull ERDViewStyle style) {
        return ArrayUtils.contains((Object[])this.attributeStyles, (Object)((Object)style));
    }

    public void setAttributeStyle(ERDViewStyle style, boolean enable) {
        this.attributeStyles = enable ? (ERDViewStyle[])ArrayUtils.add(ERDViewStyle.class, (Object[])this.attributeStyles, (Object)((Object)style)) : (ERDViewStyle[])ArrayUtils.remove(ERDViewStyle.class, (Object[])this.attributeStyles, (Object)((Object)style));
        ERDViewStyle.setDefaultStyles(ERDUIActivator.getDefault().getPreferences(), this.attributeStyles);
    }

    @Override
    public ERDAttributeVisibility getAttributeVisibility() {
        return this.attributeVisibility;
    }

    public void setAttributeVisibility(ERDAttributeVisibility attributeVisibility) {
        this.attributeVisibility = attributeVisibility;
        ERDAttributeVisibility.setDefaultVisibility((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences(), (ERDAttributeVisibility)attributeVisibility);
    }

    public void setLayoutManualAllowed(boolean layoutManualAllowed) {
        this.layoutManualAllowed = layoutManualAllowed;
    }

    public boolean isLayoutManualDesired() {
        return this.layoutManualDesired;
    }

    public void setLayoutManualDesired(boolean layoutManualDesired) {
        this.layoutManualDesired = layoutManualDesired;
    }

    public boolean isEditEnabled() {
        return this.decorator.supportsStructureEdit() && this.modelAdapter.supportsModelEdit();
    }

    public boolean isLayoutManualAllowed() {
        return this.layoutManualAllowed;
    }

    public EntityDiagram copy() {
        EntityDiagram copy = new EntityDiagram((DBSObject)this.getObject(), this.getName(), this.getContentProvider(), this.decorator);
        copy.getEntities().addAll(this.getEntities());
        copy.getEntityMap().putAll(this.getEntityMap());
        copy.layoutManualDesired = this.layoutManualDesired;
        copy.layoutManualAllowed = this.layoutManualAllowed;
        copy.noteVisuals.putAll(this.noteVisuals);
        copy.entityVisuals.putAll(this.entityVisuals);
        return copy;
    }

    public void clear() {
        super.clear();
        this.noteVisuals.clear();
        this.entityVisuals.clear();
    }

    @Nullable
    public ERDContainerDecorated.NodeVisualInfo getVisualInfo(ERDNote erdObject) {
        return this.getVisualInfo(erdObject, false);
    }

    @Nullable
    public ERDContainerDecorated.NodeVisualInfo getVisualInfo(ERDNote erdObject, boolean create) {
        ERDContainerDecorated.NodeVisualInfo visualInfo = this.noteVisuals.get(erdObject);
        if (visualInfo == null && create) {
            visualInfo = new ERDContainerDecorated.NodeVisualInfo();
            this.noteVisuals.put(erdObject, visualInfo);
        }
        return visualInfo;
    }

    @Nullable
    public ERDContainerDecorated.NodeVisualInfo getVisualInfo(DBSEntity entity) {
        return this.getVisualInfo(entity, false);
    }

    @Override
    @Nullable
    public ERDContainerDecorated.NodeVisualInfo getVisualInfo(DBSEntity entity, boolean create) {
        ERDContainerDecorated.NodeVisualInfo visualInfo = this.entityVisuals.get(entity);
        if (visualInfo == null && create) {
            visualInfo = new ERDContainerDecorated.NodeVisualInfo();
            this.entityVisuals.put(entity, visualInfo);
        }
        return visualInfo;
    }

    public void addVisualInfo(ERDNote note, ERDContainerDecorated.NodeVisualInfo visualInfo) {
        this.noteVisuals.put(note, visualInfo);
    }

    public void addVisualInfo(DBSEntity entity, ERDContainerDecorated.NodeVisualInfo visualInfo) {
        this.entityVisuals.put(entity, visualInfo);
    }

    public boolean isNeedsAutoLayout() {
        return this.needsAutoLayout;
    }

    public void setNeedsAutoLayout(boolean needsAutoLayout) {
        this.needsAutoLayout = needsAutoLayout;
    }

    public void addInitRelationBends(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, String relName, List<int[]> bends) {
        for (ERDAssociation rel : sourceEntity.getReferences()) {
            if (rel.getSourceEntity() != targetEntity || !relName.equals(((DBSEntityAssociation)rel.getObject()).getName())) continue;
            rel.setInitBends(bends);
        }
    }

    public List<ERDObject> getContents() {
        List children = super.getContents();
        children.sort((o1, o2) -> {
            ERDContainerDecorated.NodeVisualInfo vi1 = o1 instanceof ERDNote ? this.noteVisuals.get(o1) : this.entityVisuals.get(o1.getObject());
            ERDContainerDecorated.NodeVisualInfo vi2 = o2 instanceof ERDNote ? this.noteVisuals.get(o2) : this.entityVisuals.get(o2.getObject());
            return vi1 != null && vi2 != null ? vi1.zOrder - vi2.zOrder : 0;
        });
        return children;
    }
}

