/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.action;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.model.DiagramLoader;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DiagramExportAction
extends Action {
    private static final Log log = Log.getLog(DiagramExportAction.class);
    private final ERDEditorPart editor;
    private Shell shell;

    public DiagramExportAction(ERDEditorPart editor, Shell shell) {
        super("Export diagram", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.EXPORT));
        this.setDescription("Export diagram into a ERD file");
        this.setToolTipText(this.getDescription());
        this.editor = editor;
        this.shell = shell;
    }

    public void run() {
        block12: {
            try {
                String path = null;
                FileDialog dialog = new FileDialog(this.shell, 8192);
                String[] filterExt = new String[]{"*.erd"};
                dialog.setFilterExtensions(filterExt);
                path = dialog.open();
                if (path != null) {
                    String diagramState = DiagramLoader.serializeDiagram((DBRProgressMonitor)new VoidProgressMonitor(), this.editor.getDiagramPart(), this.editor.getDiagram(), false, true);
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(path), GeneralUtils.UTF8_CHARSET);){
                        osw.write(diagramState);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                log.error((Object)"Invalid path to save the image");
            }
            catch (Exception e) {
                log.error((Object)"Error saving diagram", (Throwable)e);
            }
        }
    }
}

