/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.sql.ChangeTableDataStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorTable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorDelete
extends SQLGeneratorTable {
    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
        String entityName = this.getEntityName(object);
        if (object instanceof ChangeTableDataStatement) {
            sql.append(((ChangeTableDataStatement)object).generateTableDeleteFrom(entityName));
        } else {
            sql.append("DELETE FROM ").append(entityName);
        }
        sql.append(this.getLineSeparator()).append("WHERE ");
        Collection<? extends DBSEntityAttribute> keyAttributes = this.getKeyAttributes(monitor, object);
        if (CommonUtils.isEmpty(keyAttributes)) {
            keyAttributes = this.getAllAttributes(monitor, object);
        }
        boolean hasAttr = false;
        for (DBSEntityAttribute dBSEntityAttribute : keyAttributes) {
            if (hasAttr) {
                sql.append(" AND ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
            this.appendDefaultValue(sql, (DBSAttributeBase)dBSEntityAttribute);
            hasAttr = true;
        }
        sql.append(";\n");
    }
}

