/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCTransactionIsolation;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class JDBCDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(JDBCDataSourceInfo.class);
    public static final String TERM_SCHEMA = ModelMessages.model_jdbc_Schema;
    public static final String TERM_PROCEDURE = ModelMessages.model_jdbc_Procedure;
    public static final String TERM_CATALOG = ModelMessages.model_jdbc_Database;
    private boolean readOnly;
    private String databaseProductName;
    private String databaseProductVersion;
    private String driverName;
    private String driverVersion;
    private Version databaseVersion;
    private String schemaTerm;
    private String procedureTerm;
    private String catalogTerm;
    private boolean supportsTransactions;
    private List<DBPTransactionIsolation> supportedIsolations;
    private boolean supportsReferences = true;
    private boolean supportsIndexes = true;
    private boolean supportsStoredCode = true;
    private boolean supportsBatchUpdates = false;
    private boolean supportsScroll;
    private boolean supportsViews = true;

    public JDBCDataSourceInfo(DBPDataSourceContainer container) {
        this.readOnly = false;
        this.databaseProductName = "?";
        this.databaseProductVersion = "?";
        this.driverName = container.getDriver().getName();
        this.driverVersion = "?";
        this.databaseVersion = new Version(0, 0, 0);
        this.schemaTerm = TERM_SCHEMA;
        this.procedureTerm = TERM_PROCEDURE;
        this.catalogTerm = TERM_CATALOG;
        this.supportsBatchUpdates = false;
        this.supportsTransactions = false;
        this.supportedIsolations = new ArrayList<DBPTransactionIsolation>();
        this.supportedIsolations.add(0, JDBCTransactionIsolation.NONE);
        this.supportsScroll = true;
    }

    public JDBCDataSourceInfo(JDBCDatabaseMetaData metaData) {
        if (!this.isIgnoreReadOnlyFlag()) {
            try {
                this.readOnly = metaData.isReadOnly();
            }
            catch (Throwable e) {
                log.debug(e.getMessage());
                this.readOnly = false;
            }
        } else {
            this.readOnly = false;
        }
        try {
            this.databaseProductName = metaData.getDatabaseProductName();
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.databaseProductName = "?";
        }
        try {
            this.databaseProductVersion = metaData.getDatabaseProductVersion();
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.databaseProductVersion = "?";
        }
        try {
            String name = metaData.getDriverName();
            if (name != null) {
                this.driverName = name;
            }
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.driverName = "?";
        }
        try {
            this.driverVersion = metaData.getDriverVersion();
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.driverVersion = "?";
        }
        try {
            this.databaseVersion = new Version(metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), 0);
        }
        catch (Throwable throwable) {
            try {
                this.databaseVersion = new Version(this.databaseProductVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug("Can't determine database version. Use default");
                this.databaseVersion = new Version(0, 0, 0);
            }
        }
        try {
            this.schemaTerm = this.makeTermString(metaData.getSchemaTerm(), TERM_SCHEMA);
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.schemaTerm = TERM_SCHEMA;
        }
        try {
            this.procedureTerm = this.makeTermString(metaData.getProcedureTerm(), TERM_PROCEDURE);
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.procedureTerm = TERM_PROCEDURE;
        }
        try {
            this.catalogTerm = this.makeTermString(metaData.getCatalogTerm(), TERM_CATALOG);
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.catalogTerm = TERM_CATALOG;
        }
        try {
            this.supportsBatchUpdates = metaData.supportsBatchUpdates();
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
        }
        try {
            this.supportsTransactions = metaData.supportsTransactions();
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            this.supportsTransactions = true;
        }
        this.supportedIsolations = new ArrayList<DBPTransactionIsolation>();
        if (this.supportsTransactions) {
            try {
                JDBCTransactionIsolation[] jDBCTransactionIsolationArray = JDBCTransactionIsolation.values();
                int n = jDBCTransactionIsolationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JDBCTransactionIsolation txi = jDBCTransactionIsolationArray[n2];
                    if (metaData.supportsTransactionIsolationLevel(txi.getCode())) {
                        this.supportedIsolations.add(txi);
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                log.debug(e.getMessage());
            }
            if (!this.supportedIsolations.contains(JDBCTransactionIsolation.NONE)) {
                this.supportedIsolations.add(0, JDBCTransactionIsolation.NONE);
            }
            this.addCustomTransactionIsolationLevels(this.supportedIsolations);
        }
        this.supportsScroll = true;
    }

    protected void addCustomTransactionIsolationLevels(List<DBPTransactionIsolation> isolations) {
    }

    protected boolean isIgnoreReadOnlyFlag() {
        return true;
    }

    private String makeTermString(String term, String defTerm) {
        return CommonUtils.isEmpty((String)term) ? defTerm : CommonUtils.capitalizeWord((String)term.toLowerCase());
    }

    @Override
    public boolean isReadOnlyData() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnlyMetaData() {
        return this.readOnly;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public Version getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    @Override
    public String getProcedureTerm() {
        return this.procedureTerm;
    }

    @Override
    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    @Override
    public boolean supportsTransactions() {
        return this.supportsTransactions;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsReferentialIntegrity() {
        return this.supportsReferences;
    }

    public void setSupportsReferences(boolean supportsReferences) {
        this.supportsReferences = supportsReferences;
    }

    @Override
    public boolean supportsIndexes() {
        return this.supportsIndexes;
    }

    public void setSupportsIndexes(boolean supportsIndexes) {
        this.supportsIndexes = supportsIndexes;
    }

    public boolean supportsViews() {
        return this.supportsViews;
    }

    public void setSupportsViews(boolean supportsViews) {
        this.supportsViews = supportsViews;
    }

    @Override
    public boolean supportsStoredCode() {
        return this.supportsStoredCode;
    }

    public void setSupportsStoredCode(boolean supportsStoredCode) {
        this.supportsStoredCode = supportsStoredCode;
    }

    @Override
    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return this.supportedIsolations;
    }

    @Override
    public boolean supportsResultSetLimit() {
        return true;
    }

    @Override
    public boolean supportsResultSetScroll() {
        return this.supportsScroll;
    }

    @Override
    public boolean isDynamicMetadata() {
        return false;
    }

    @Override
    public boolean supportsMultipleResults() {
        return false;
    }

    @Override
    public boolean isMultipleResultsFetchBroken() {
        return false;
    }

    @Override
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_VIEW_COLUMN, RelationalObjectType.TYPE_INDEX, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_SEQUENCE, RelationalObjectType.TYPE_TRIGGER, RelationalObjectType.TYPE_DATA_TYPE};
    }

    public void setSupportsResultSetScroll(boolean supportsScroll) {
        this.supportsScroll = supportsScroll;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    public boolean supportsSetArray() {
        return false;
    }
}

