/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPEditorContribution;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.utils.CommonUtils;

public class EditorContributionDescriptor
extends AbstractContextDescriptor
implements DBPEditorContribution {
    private static final Log log = Log.getLog(EditorContributionDescriptor.class);
    private final String editorId;
    private final String category;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final List<String> supportedDataSources = new ArrayList<String>();
    private final List<String> supportedDrivers = new ArrayList<String>();

    public EditorContributionDescriptor(IConfigurationElement config) {
        super(config);
        this.editorId = config.getAttribute("editorId");
        this.category = config.getAttribute("category");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("supports");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportsDrivers;
            IConfigurationElement supportsCfg = iConfigurationElementArray[n2];
            String supportsDS = supportsCfg.getAttribute("dataSource");
            if (!CommonUtils.isEmpty((String)supportsDS)) {
                this.supportedDataSources.addAll(Arrays.asList(supportsDS.split(",")));
            }
            if (!CommonUtils.isEmpty((String)(supportsDrivers = supportsCfg.getAttribute("driver")))) {
                this.supportedDrivers.addAll(Arrays.asList(supportsDrivers.split(",")));
            }
            ++n2;
        }
    }

    public String getEditorId() {
        return this.editorId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean supportsDataSource(DBPDataSourceContainer dataSource) {
        if (this.supportedDataSources.isEmpty() && this.supportedDrivers.isEmpty()) {
            return true;
        }
        if (!this.supportedDataSources.isEmpty() && !this.supportedDataSources.contains(dataSource.getDriver().getProviderId())) {
            return false;
        }
        return this.supportedDrivers.isEmpty() || this.supportedDrivers.contains(dataSource.getDriver().getId());
    }

    public String toString() {
        return String.valueOf(this.editorId) + "(" + this.category + ")";
    }
}

