/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.bool;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.RGB;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;

public class BooleanStyle {
    private final BooleanMode mode;
    private final String text;
    private final DBIcon icon;
    private final UIElementAlignment alignment;
    private final RGB color;

    private BooleanStyle(@NotNull BooleanMode mode, @Nullable String text, @Nullable DBIcon icon, @NotNull UIElementAlignment alignment, @Nullable RGB color) {
        this.mode = mode;
        this.text = text;
        this.icon = icon;
        this.alignment = alignment;
        this.color = color;
        Assert.isLegal((mode != BooleanMode.TEXT || text != null && icon == null && color != null ? 1 : 0) != 0, (String)"Only text and color must be present in text style");
        Assert.isLegal((mode != BooleanMode.ICON || text == null && icon != null && color == null ? 1 : 0) != 0, (String)"Only icon must be present in icon style");
    }

    @NotNull
    public static BooleanStyle usingText(@NotNull String text, @NotNull UIElementAlignment alignment, @NotNull RGB color) {
        return new BooleanStyle(BooleanMode.TEXT, text, null, alignment, color);
    }

    @NotNull
    public static BooleanStyle usingIcon(@NotNull DBIcon icon, @NotNull UIElementAlignment alignment) {
        return new BooleanStyle(BooleanMode.ICON, null, icon, alignment, null);
    }

    @NotNull
    public BooleanMode getMode() {
        return this.mode;
    }

    @NotNull
    public String getText() {
        Assert.isLegal((this.mode == BooleanMode.TEXT ? 1 : 0) != 0);
        return this.text;
    }

    @NotNull
    public DBIcon getIcon() {
        Assert.isLegal((this.mode == BooleanMode.ICON ? 1 : 0) != 0);
        return this.icon;
    }

    @NotNull
    public UIElementAlignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public RGB getColor() {
        Assert.isLegal((this.mode == BooleanMode.TEXT ? 1 : 0) != 0);
        return this.color;
    }
}

