/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.Request;

public class ToolUtilities {
    public static List getSelectionWithoutDependants(EditPartViewer viewer) {
        List selectedParts = viewer.getSelectedEditParts();
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        int i = 0;
        while (i < selectedParts.size()) {
            EditPart editpart = (EditPart)selectedParts.get(i);
            if (!ToolUtilities.isAncestorContainedIn(selectedParts, editpart)) {
                result.add(editpart);
            }
            ++i;
        }
        return result;
    }

    public static List getSelectionWithoutDependants(List selectedParts) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        int i = 0;
        while (i < selectedParts.size()) {
            EditPart editpart = (EditPart)selectedParts.get(i);
            if (!ToolUtilities.isAncestorContainedIn(selectedParts, editpart)) {
                result.add(editpart);
            }
            ++i;
        }
        return result;
    }

    public static void filterEditPartsUnderstanding(List list, Request request) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            EditPart ep = (EditPart)iter.next();
            if (ep.understandsRequest(request)) continue;
            iter.remove();
        }
    }

    public static boolean isAncestorContainedIn(Collection c, EditPart ep) {
        ep = ep.getParent();
        while (ep != null) {
            if (c.contains(ep)) {
                return true;
            }
            ep = ep.getParent();
        }
        return false;
    }

    public static EditPart findCommonAncestor(EditPart ll, EditPart rr) {
        if (ll == rr) {
            return ll;
        }
        ArrayList<EditPart> leftAncestors = new ArrayList<EditPart>();
        ArrayList<EditPart> rightAncestors = new ArrayList<EditPart>();
        EditPart l = ll;
        EditPart r = rr;
        while (l != null) {
            leftAncestors.add(l);
            l = l.getParent();
        }
        while (r != null) {
            rightAncestors.add(r);
            r = r.getParent();
        }
        int il = leftAncestors.size() - 1;
        int ir = rightAncestors.size() - 1;
        while (leftAncestors.get(il) == rightAncestors.get(ir) && --il >= 0 && --ir >= 0) {
        }
        return (EditPart)leftAncestors.get(il + 1);
    }
}

