/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.itemlist;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ClipboardData;
import org.jkiss.dbeaver.ui.CopyMode;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

public abstract class DatabaseObjectListControl<OBJECT_TYPE extends DBPObject>
extends ObjectListControl<OBJECT_TYPE> {
    private IWorkbenchSite site;

    protected DatabaseObjectListControl(Composite parent, int style, IWorkbenchSite site, IContentProvider contentProvider) {
        super(parent, style, contentProvider);
        this.site = site;
        this.setFitWidth(true);
        this.createContextMenu();
    }

    @Override
    protected ObjectViewerRenderer createRenderer() {
        return new ObjectListRenderer();
    }

    private void createContextMenu() {
        NavigatorUtils.createContextMenu(this.site, (Viewer)this.getItemsViewer(), manager -> {
            Action copyAction = new Action(WorkbenchMessages.Workbench_copy){

                public void run() {
                    ClipboardData clipboardData = new ClipboardData();
                    DatabaseObjectListControl.this.addClipboardData(CopyMode.DEFAULT, clipboardData);
                    clipboardData.pushToClipboard(DatabaseObjectListControl.this.getDisplay());
                }
            };
            manager.add((IAction)copyAction);
            Action copyAllAction = new Action(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.edit.copy.special")){

                public void run() {
                    ClipboardData clipboardData = new ClipboardData();
                    DatabaseObjectListControl.this.addClipboardData(CopyMode.ADVANCED, clipboardData);
                    clipboardData.pushToClipboard(DatabaseObjectListControl.this.getDisplay());
                }
            };
            manager.add((IAction)copyAllAction);
            manager.add((IContributionItem)new Separator());
            this.fillCustomActions((IContributionManager)manager);
        });
    }

    private class ObjectListRenderer
    extends ObjectListControl.ViewerRenderer {
        private ObjectListRenderer() {
            super(DatabaseObjectListControl.this);
        }

        public boolean isHyperlink(Object cellValue) {
            return cellValue instanceof DBSObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)cellValue);
            }
        }
    }
}

