/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.config;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerLogin;
import org.jkiss.dbeaver.ext.mssql.ui.SQLServerUIMessages;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class SQLServerLoginConfigurator
implements DBEObjectConfigurator<SQLServerLogin> {
    public SQLServerLogin configureObject(DBRProgressMonitor monitor, Object container, final SQLServerLogin login) {
        return (SQLServerLogin)new UITask<SQLServerLogin>(){

            protected SQLServerLogin runTask() {
                SQLServerCreateLoginDialog dialog = new SQLServerCreateLoginDialog(UIUtils.getActiveWorkbenchShell());
                if (dialog.open() != 0) {
                    return null;
                }
                login.setLoginName(dialog.getName());
                login.setPassword(dialog.getPassword());
                return login;
            }
        }.execute();
    }

    class SQLServerCreateLoginDialog
    extends BaseDialog {
        private String name;
        private String password;

        SQLServerCreateLoginDialog(Shell parentShell) {
            super(parentShell, SQLServerUIMessages.dialog_create_login_shell_title, null);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Group groupGeneral = UIUtils.createControlGroup((Composite)composite, (String)SQLServerUIMessages.dialog_create_login_group, (int)2, (int)768, (int)0);
            Text nameText = UIUtils.createLabelText((Composite)groupGeneral, (String)SQLServerUIMessages.dialog_create_login_label_name, (String)"");
            nameText.addModifyListener(e -> {
                this.name = nameText.getText().trim();
                this.getButton(0).setEnabled(!this.name.isEmpty() && this.password != null && !this.password.isEmpty());
            });
            Text passwordText = UIUtils.createLabelText((Composite)groupGeneral, (String)SQLServerUIMessages.dialog_create_login_label_password, (String)"", (int)0x400800);
            passwordText.addModifyListener(e -> {
                this.password = passwordText.getText();
                this.getButton(0).setEnabled(!this.password.isEmpty() && !this.name.isEmpty());
            });
            return composite;
        }

        String getName() {
            return this.name;
        }

        String getPassword() {
            return this.password;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }
    }
}

