/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.geometry;

import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;

public class Geometry {
    public static boolean linesIntersect(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int bb1_x = Math.min(x1, x2);
        int bb1_y = Math.min(y1, y2);
        int bb2_x = Math.max(x1, x2);
        int bb2_y = Math.max(y1, y2);
        int bb3_x = Math.min(x3, x4);
        int bb3_y = Math.min(y3, y4);
        int bb4_x = Math.max(x3, x4);
        int bb4_y = Math.max(y3, y4);
        if (bb2_x < bb3_x || bb4_x < bb1_x || bb2_y < bb3_y || bb4_y < bb1_y) {
            return false;
        }
        long p1p3_x = (long)x1 - (long)x3;
        long p1p3_y = (long)y1 - (long)y3;
        long p2p3_x = (long)x2 - (long)x3;
        long p2p3_y = (long)y2 - (long)y3;
        long p3p4_x = (long)x3 - (long)x4;
        long p3p4_y = (long)y3 - (long)y4;
        if (Geometry.productSign(Geometry.crossProduct(p2p3_x, p2p3_y, p3p4_x, p3p4_y), Geometry.crossProduct(p3p4_x, p3p4_y, p1p3_x, p1p3_y)) >= 0) {
            long p2p1_x = (long)x2 - (long)x1;
            long p2p1_y = (long)y2 - (long)y1;
            long p1p4_x = (long)x1 - (long)x4;
            long p1p4_y = (long)y1 - (long)y4;
            return Geometry.productSign(Geometry.crossProduct(-p1p3_x, -p1p3_y, p2p1_x, p2p1_y), Geometry.crossProduct(p2p1_x, p2p1_y, p1p4_x, p1p4_y)) <= 0;
        }
        return false;
    }

    private static int productSign(long x, long y) {
        if (x == 0L || y == 0L) {
            return 0;
        }
        if (x < 0L ^ y < 0L) {
            return -1;
        }
        return 1;
    }

    private static long crossProduct(long x1, long y1, long x2, long y2) {
        return x1 * y2 - x2 * y1;
    }

    public static boolean polylineContainsPoint(PointList points, int x, int y, int tolerance) {
        int[] coordinates = points.toIntArray();
        int index = 0;
        while (index < coordinates.length - 3) {
            if (Geometry.segmentContainsPoint(coordinates[index], coordinates[index + 1], coordinates[index + 2], coordinates[index + 3], x, y, tolerance)) {
                return true;
            }
            index += 2;
        }
        return false;
    }

    private static boolean segmentContainsPoint(int x1, int y1, int x2, int y2, int px, int py, int tolerance) {
        Rectangle lineBounds = Rectangle.SINGLETON;
        lineBounds.setSize(0, 0);
        lineBounds.setLocation(x1, y1);
        lineBounds.union(x2, y2);
        lineBounds.expand(tolerance, tolerance);
        if (!lineBounds.contains(px, py)) {
            return false;
        }
        if (x1 == x2 || y1 == y2) {
            return true;
        }
        long v2x = px - x1;
        long v1y = y2 - y1;
        long v1x = x2 - x1;
        long v2y = py - y1;
        long numerator = v2x * v1y - v1x * v2y;
        long denominator = v1x * v1x + v1y * v1y;
        long squareDistance = numerator * numerator / denominator;
        return squareDistance <= (long)(tolerance * tolerance);
    }

    public static boolean polygonContainsPoint(PointList points, int x, int y) {
        boolean isOdd = false;
        int[] coordinates = points.toIntArray();
        int n = coordinates.length;
        if (n > 3) {
            int x0 = coordinates[n - 2];
            int y0 = coordinates[n - 1];
            int i = 0;
            while (i < n) {
                int y1;
                int x1 = coordinates[i++];
                if (Geometry.segmentContaintPoint(y0, y1 = coordinates[i++], y)) {
                    int crossProduct = Geometry.crossProduct(x1, y1, x0, y0, x, y);
                    if (crossProduct == 0) {
                        if (Geometry.segmentContaintPoint(x0, x1, x)) {
                            return true;
                        }
                    } else if (y0 <= y && y < y1 && crossProduct > 0 || y1 <= y && y < y0 && crossProduct < 0) {
                        isOdd = !isOdd;
                    }
                }
                x0 = x1;
                y0 = y1;
            }
            return isOdd;
        }
        return false;
    }

    private static boolean segmentContaintPoint(int x0, int x1, int x) {
        return !(x < x0 && x < x1 || x > x0 && x > x1);
    }

    private static int crossProduct(int ax, int ay, int bx, int by, int cx, int cy) {
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }
}

