/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.mapping;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.provider.MergeStatus;

public abstract class ResourceMappingMerger
implements IResourceMappingMerger {
    @Override
    public IStatus validateMerge(IMergeContext mergeContext, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected abstract ModelProvider getModelProvider();

    @Override
    public ISchedulingRule getMergeRule(IMergeContext context) {
        ResourceMapping[] mappings = context.getScope().getMappings(this.getModelProvider().getId());
        Object rule = null;
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            IProject[] mappingProjects;
            ResourceMapping mapping = resourceMappingArray[n2];
            IProject[] iProjectArray = mappingProjects = mapping.getProjects();
            int n3 = mappingProjects.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject project = iProjectArray[n4];
                rule = rule == null ? project : MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)project);
                ++n4;
            }
            ++n2;
        }
        return rule;
    }

    @Override
    public IStatus merge(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        IDiff[] deltas = this.getSetToMerge(mergeContext);
        IStatus status = mergeContext.merge(deltas, false, monitor);
        return this.covertFilesToMappings(status, mergeContext);
    }

    private IDiff[] getSetToMerge(IMergeContext mergeContext) {
        ResourceMapping[] mappings = mergeContext.getScope().getMappings(this.getModelProvider().getDescriptor().getId());
        HashSet result = new HashSet();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ResourceTraversal[] traversals = mergeContext.getScope().getTraversals(mapping);
            IDiff[] deltas = mergeContext.getDiffTree().getDiffs(traversals);
            Collections.addAll(result, deltas);
            ++n2;
        }
        return result.toArray(new IDiff[result.size()]);
    }

    private IStatus covertFilesToMappings(IStatus status, IMergeContext mergeContext) {
        if (status.getCode() == 1) {
            return new MergeStatus(status.getPlugin(), status.getMessage(), mergeContext.getScope().getMappings(this.getModelProvider().getDescriptor().getId()));
        }
        return status;
    }
}

