/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ExasolSQLDialect
extends JDBCSQLDialect {
    private static final Log LOG = Log.getLog(ExasolDataSource.class);
    public static final String[] EXEC_KEYWORDS = new String[0];

    public ExasolSQLDialect() {
        super("Exasol", "exasol");
    }

    public void addExtraFunctions(String ... functions) {
        super.addFunctions(Arrays.asList(functions));
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        Collections.addAll(this.tableQueryWords, "DESC");
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCStatement stmt = session.createStatement();){
                String keyWord;
                JDBCResultSet dbResult;
                Throwable throwable2 = null;
                Object var8_12 = null;
                try {
                    dbResult = stmt.executeQuery("/*snapshot execution*/ SELECT \"VALUE\" FROM \"$ODBCJDBC\".DB_METADATA WHERE name = 'aggregateFunctions'");
                    try {
                        if (dbResult.next()) {
                            keyWord = dbResult.getString(1);
                            String[] aggregateFunctions = keyWord.split(",");
                            this.addExtraFunctions(aggregateFunctions);
                        }
                    }
                    finally {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                throwable2 = null;
                var8_12 = null;
                try {
                    dbResult = stmt.executeQuery("/*snapshot execution*/ SELECT keyword FROM sys.EXA_SQL_KEYWORDS esk WHERE RESERVED");
                    try {
                        while (dbResult.next()) {
                            keyWord = dbResult.getString("KEYWORD");
                            super.addSQLKeyword(keyWord);
                        }
                    }
                    finally {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            LOG.warn((Object)"Could not retrieve functions list from Exasol dictionary");
        }
        ArrayList<String> value = new ArrayList<String>(){
            {
                this.add("KERBEROS");
                this.add("JDBC");
                this.add("BYTE");
                this.add("BIT");
                this.add("PRECEDENCE");
                this.add("GROUP_TEMP_DB_RAM_LIMIT");
                this.add("USER_TEMP_DB_RAM_LIMIT");
                this.add("SESSION_TEMP_DB_RAM_LIMIT");
                this.add("CPU_WEIGHT");
            }
        };
        this.addKeywords(value, DBPKeywordType.KEYWORD);
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return new String[]{"EXECUTE SCRIPT"};
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        return super.escapeScriptValue(attribute, value, strValue);
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }
}

