/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;

public abstract class SQLGeneratorResultSet
extends SQLGeneratorBase<IResultSetController> {
    public IResultSetController getController() {
        return (IResultSetController)this.objects.get(0);
    }

    public List<ResultSetRow> getSelectedRows() {
        return this.getController().getSelection().getSelectedRows();
    }

    public DBSEntity getSingleEntity() {
        return this.getController().getModel().getSingleSource();
    }

    protected abstract void generateSQL(DBRProgressMonitor var1, StringBuilder var2, IResultSetController var3) throws DBException;

    protected Collection<? extends DBSAttributeBase> getAllAttributes(DBRProgressMonitor monitor, IResultSetController object) {
        return object.getModel().getVisibleAttributes();
    }

    void appendValueCondition(IResultSetController rsv, StringBuilder sql, DBDAttributeBinding binding, ResultSetRow firstRow) {
        Object value = rsv.getModel().getCellValue(binding, firstRow);
        sql.append(DBUtils.getObjectFullName((DBPNamedObject)binding.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        if (DBUtils.isNullValue((Object)value)) {
            sql.append(" IS NULL");
        } else {
            sql.append("=");
            this.appendAttributeValue(rsv, sql, binding, firstRow);
        }
    }

    protected List<DBDAttributeBinding> getKeyAttributes(DBRProgressMonitor monitor, IResultSetController object) {
        DBDRowIdentifier rowIdentifier = this.getDefaultRowIdentifier(object);
        if (rowIdentifier == null) {
            return Collections.emptyList();
        }
        return rowIdentifier.getAttributes();
    }

    @Nullable
    private DBDRowIdentifier getDefaultRowIdentifier(IResultSetController object) {
        DBDAttributeBinding[] dBDAttributeBindingArray = object.getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            DBDRowIdentifier rowIdentifier = attr.getRowIdentifier();
            if (rowIdentifier != null) {
                return rowIdentifier;
            }
            ++n2;
        }
        return null;
    }

    protected void appendAttributeValue(IResultSetController rsv, StringBuilder sql, DBDAttributeBinding binding, ResultSetRow row) {
        DBPDataSource dataSource = binding.getDataSource();
        Object value = rsv.getModel().getCellValue(binding, row);
        DBSAttributeBase attribute = binding.getAttribute();
        if (attribute != null && attribute.getDataKind() == DBPDataKind.DATETIME && this.isUseCustomDataFormat()) {
            sql.append(SQLUtils.quoteString((DBPDataSource)dataSource, (String)SQLUtils.convertValueToSQL((DBPDataSource)dataSource, (DBSTypedObject)attribute, (DBDValueHandler)DBUtils.findValueHandler((DBPDataSource)dataSource, (DBSTypedObject)attribute), (Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI)));
        } else {
            sql.append(SQLUtils.convertValueToSQL((DBPDataSource)dataSource, (DBSTypedObject)attribute, (Object)value));
        }
    }
}

