/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BlockingPopupDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StandardErrorDialog
extends ErrorDialog
implements BlockingPopupDialog {
    private static final String DIALOG_ID = "DBeaver.StandardErrorDialog";
    private Text messageText;
    private boolean detailsVisible = false;
    private static final int MAX_AUTO_SIZE_X = 500;
    private static final int MAX_AUTO_SIZE_Y = 300;

    public StandardErrorDialog(@NotNull Shell parentShell, @NotNull String dialogTitle, @Nullable String message, @NotNull IStatus status, int displayMask) {
        super(parentShell, dialogTitle, message, status, displayMask);
        this.setStatus(status);
        if (message == null) {
            IStatus rootStatus = GeneralUtils.getRootStatus((IStatus)status);
            if (rootStatus.getException() != null) {
                String lastMessage = null;
                Throwable e = rootStatus.getException();
                while (e != null) {
                    if (e.getMessage() != null) {
                        lastMessage = e.getMessage();
                    }
                    e = e.getCause();
                }
                if (CommonUtils.isEmpty(lastMessage) && CommonUtils.isEmpty((String)(lastMessage = rootStatus.getMessage())) && CommonUtils.isEmpty((String)(lastMessage = status.getMessage())) && rootStatus.getException() != null) {
                    lastMessage = rootStatus.getException().getClass().getName();
                }
                this.message = CommonUtils.cutExtraLines((String)lastMessage, (int)20);
            } else {
                this.message = CommonUtils.cutExtraLines((String)rootStatus.getMessage(), (int)20);
            }
        } else {
            this.message = CommonUtils.cutExtraLines((String)JFaceResources.format((String)"Reason", (Object[])new Object[]{message, status.getMessage()}), (int)20);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        return this.createMessageArea(parent);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.messageText = new Text(composite, 2632);
            this.messageText.setText(this.message);
            GridData gd = new GridData(1808);
            gd.minimumWidth = 300;
            gd.heightHint = UIUtils.getFontHeight((Control)composite) * 10;
            gd.grabExcessVerticalSpace = true;
            gd.grabExcessHorizontalSpace = true;
            this.messageText.setLayoutData((Object)gd);
        }
        return composite;
    }

    public void create() {
        super.create();
        Point prefSize = this.getContents().computeSize(-1, -1);
        Point actualSize = this.getShell().getSize();
        if (prefSize.x < 500 && prefSize.x > actualSize.x || prefSize.y < 300 && prefSize.y > actualSize.y) {
            if (prefSize.x > actualSize.x) {
                actualSize.x = prefSize.x;
            }
            if (prefSize.y > actualSize.y) {
                actualSize.y = prefSize.y;
            }
            this.getShell().setSize(actualSize);
        }
        this.detailsVisible = this.getDialogBoundsSettings().getBoolean("showDetails");
        if (this.detailsVisible) {
            this.showDetailsArea();
        }
        UIUtils.asyncExec(() -> {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setFocus();
            }
        });
    }

    protected List createDropDownList(Composite parent) {
        this.detailsVisible = true;
        List dropDownList = super.createDropDownList(parent);
        dropDownList.addDisposeListener(e -> {
            this.detailsVisible = false;
        });
        int itemCount = dropDownList.getItemCount();
        if (itemCount > 1) {
            dropDownList.remove(itemCount - 1);
        }
        return dropDownList;
    }

    public Image getErrorImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
    }

    public Image getWarningImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING);
    }

    public Image getInfoImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO);
    }

    public boolean close() {
        this.getDialogBoundsSettings().put("showDetails", this.detailsVisible);
        return super.close();
    }
}

