/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;

public class DBNUtils {
    private static final Log log = Log.getLog(DBNUtils.class);

    public static DBNDatabaseNode getNodeByObject(DBSObject object) {
        return DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(object);
    }

    public static DBNDatabaseNode getNodeByObject(DBRProgressMonitor monitor, DBSObject object, boolean addFiltered) {
        return DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(monitor, object, addFiltered);
    }

    public static DBNDatabaseNode getChildFolder(DBRProgressMonitor monitor, DBNDatabaseNode node, Class<?> folderType) {
        try {
            DBNDatabaseNode[] dBNDatabaseNodeArray = node.getChildren(monitor);
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBXTreeFolder meta;
                Class<?> objectClass;
                DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
                if (childNode instanceof DBNDatabaseFolder && (objectClass = (meta = ((DBNDatabaseFolder)childNode).getMeta()).getSource().getObjectClass(meta.getType())) != null && folderType.isAssignableFrom(objectClass)) {
                    return childNode;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            log.error("Error reading child folder", e);
        }
        return null;
    }

    public static DBNNode[] getNodeChildrenFiltered(DBRProgressMonitor monitor, DBNNode node, boolean forTree) throws DBException {
        DBNNode[] children = node.getChildren(monitor);
        if (children != null && children.length > 0) {
            children = DBNUtils.filterNavigableChildren(children, forTree);
        }
        return children;
    }

    public static DBNNode[] filterNavigableChildren(DBNNode[] children, boolean forTree) {
        DBNNode[] result;
        if (ArrayUtils.isEmpty((Object[])children)) {
            return children;
        }
        if (forTree) {
            ArrayList<DBNNode> filtered = new ArrayList<DBNNode>();
            int i = 0;
            while (i < children.length) {
                DBNDatabaseNode dbNode;
                DBNNode node = children[i];
                if (!(node instanceof DBPHiddenObject && ((DBPHiddenObject)((Object)node)).isHidden() || node instanceof DBNDatabaseNode && (dbNode = (DBNDatabaseNode)node).getMeta() != null && !dbNode.getMeta().isNavigable())) {
                    filtered.add(node);
                }
                ++i;
            }
            result = filtered.toArray(new DBNNode[0]);
        } else {
            result = children;
        }
        DBNUtils.sortNodes(result);
        return result;
    }

    private static void sortNodes(DBNNode[] children) {
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (children.length > 0 && prefStore.getBoolean("navigator.sort.case.insensitive") && !(children[0] instanceof DBNContainer)) {
            Arrays.sort(children, NodeNameComparator.INSTANCE);
        }
        if (children.length > 0 && prefStore.getBoolean("navigator.sort.forlers.first")) {
            Arrays.sort(children, NodeFolderComparator.INSTANCE);
        }
    }

    public static boolean isDefaultElement(Object element) {
        if (element instanceof DBSWrapper) {
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext defaultContext;
            DBSObject object = ((DBSWrapper)element).getObject();
            if (object != null && (defaultContext = DBUtils.getDefaultContext(object.getDataSource(), false)) != null && (contextDefaults = defaultContext.getContextDefaults()) != null) {
                return contextDefaults.getDefaultCatalog() == object || contextDefaults.getDefaultSchema() == object;
            }
        } else if (element instanceof DBNProject && ((DBNProject)element).getProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject()) {
            return true;
        }
        return false;
    }

    public static void refreshNavigatorResource(@NotNull IResource resource, Object source) {
        DBNResource fileNode;
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(resource.getProject());
        if (projectNode != null && (fileNode = projectNode.findResource(resource)) != null) {
            fileNode.refreshResourceState(source);
        }
    }

    @NotNull
    public static String getLastNodePathSegment(@NotNull String path) {
        int divPos = path.lastIndexOf(47);
        return divPos == -1 ? path : path.substring(divPos + 1);
    }

    public static boolean isReadOnly(DBNNode node) {
        return node instanceof DBNDatabaseNode && !(node instanceof DBNDataSource) && !((DBNDatabaseNode)node).getDataSourceContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA);
    }

    private static class NodeFolderComparator
    implements Comparator<DBNNode> {
        static NodeFolderComparator INSTANCE = new NodeFolderComparator();

        private NodeFolderComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            int first = node1 instanceof DBNLocalFolder || node1 instanceof DBSFolder ? -1 : 1;
            int second = node2 instanceof DBNLocalFolder || node2 instanceof DBSFolder ? -1 : 1;
            return first - second;
        }
    }

    private static class NodeNameComparator
    implements Comparator<DBNNode> {
        static NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            return node1.getNodeName().compareToIgnoreCase(node2.getNodeName());
        }
    }
}

