/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.colors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ColorSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ColorSettingsDialog.class);
    private static final String DIALOG_ID = "DBeaver.ColorSettingsDialog2";
    private static final DBCLogicalOperator[] SUPPORTED_OPERATORS = new DBCLogicalOperator[]{DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.GREATER, DBCLogicalOperator.GREATER_EQUALS, DBCLogicalOperator.LESS, DBCLogicalOperator.LESS_EQUALS, DBCLogicalOperator.ILIKE, DBCLogicalOperator.LIKE, DBCLogicalOperator.NOT_LIKE, DBCLogicalOperator.REGEX};
    private static RGB DEFAULT_RGB;
    @NotNull
    private final ResultSetViewer resultSetViewer;
    @Nullable
    private DBDAttributeBinding attribute;
    @Nullable
    private ResultSetRow row;
    private final DBVEntity vEntitySrc;
    private final DBVEntity vEntity;
    private Table colorsTable;
    private Combo operatorCombo;
    private Button rangeCheck;
    private ColorSelector bgColorSelector1;
    private ColorSelector bgColorSelector2;
    private ColorSelector fgColorSelector1;
    private ColorSelector fgColorSelector2;
    private IValueEditor valueEditor1;
    private IValueEditor valueEditor2;
    private ControlEnableState settingsEnableState;
    private Composite settingsGroup;
    private List<DBVColorOverride> colorOverrides;
    private Button singleColumnCheck;
    private DBVColorOverride curOverride;
    private ToolItem btnDelete;
    private Table attributeTable;
    private Composite editorPlaceholder1;
    private Composite editorPlaceholder2;

    public ColorSettingsDialog(@NotNull ResultSetViewer resultSetViewer, @NotNull DBVEntity vEntity, @NotNull DBDAttributeBinding attr, @Nullable ResultSetRow row) {
        super(resultSetViewer.getControl().getShell(), NLS.bind((String)ResultSetMessages.dialog_row_colors_title, (Object)attr.getDataContainer().getName()), (DBPImage)UIIcon.PALETTE);
        this.resultSetViewer = resultSetViewer;
        this.attribute = attr;
        this.row = row;
        this.vEntitySrc = vEntity;
        this.vEntity = new DBVEntity(this.vEntitySrc.getContainer(), this.vEntitySrc, this.vEntitySrc.getModel());
        DEFAULT_RGB = resultSetViewer.getControl().getDisplay().getSystemColor(22).getRGB();
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        SashForm divider = new SashForm(composite, 256);
        divider.setSashWidth(10);
        divider.setLayoutData((Object)new GridData(1808));
        this.createAttributeSelectorArea((Composite)divider);
        this.createAttributeSettingsArea((Composite)divider);
        this.updateAttributeSelection();
        return parent;
    }

    private void createAttributeSelectorArea(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        this.attributeTable = new Table(panel, 67584);
        this.attributeTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        this.attributeTable.setLayoutData((Object)gd);
        UIUtils.executeOnResize((Control)this.attributeTable, () -> UIUtils.packColumns((Table)this.attributeTable, (boolean)true));
        UIUtils.createTableColumn((Table)this.attributeTable, (int)16384, (String)ResultSetMessages.dialog_row_colors_table_attributes_name);
        UIUtils.createTableColumn((Table)this.attributeTable, (int)16384, (String)ResultSetMessages.dialog_row_colors_table_attributes_color);
        for (DBDAttributeBinding attr : this.resultSetViewer.getModel().getVisibleAttributes()) {
            TableItem attrItem = new TableItem(this.attributeTable, 0);
            attrItem.setData((Object)attr);
            attrItem.setText(0, attr.getName());
            attrItem.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attr, (boolean)true)));
            if (this.attribute != attr) continue;
            this.attributeTable.setSelection(attrItem);
        }
        this.attributeTable.addListener(42, event -> {
            if (event.index == 1) {
                int x = event.x + 4;
                DBDAttributeBinding attr = (DBDAttributeBinding)event.item.getData();
                List coList = this.vEntity.getColorOverrides(attr.getName());
                if (!coList.isEmpty()) {
                    for (DBVColorOverride co : coList) {
                        ArrayList<String> coStrings = new ArrayList<String>();
                        if (co.getAttributeValues() != null) {
                            Object[] objectArray = co.getAttributeValues();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object value = objectArray[n2];
                                coStrings.add(CommonUtils.toString((Object)value));
                                ++n2;
                            }
                        }
                        int boxSize = this.attributeTable.getItemHeight() - 4;
                        Point textSize = new Point(boxSize, boxSize);
                        Color fg = this.attributeTable.getDisplay().getSystemColor(18);
                        Color bg = this.getColorTableBackground(co);
                        if (fg != null) {
                            event.gc.setForeground(fg);
                        }
                        if (bg != null) {
                            event.gc.setBackground(bg);
                        }
                        event.gc.fillRectangle(x, event.y + 2, textSize.x, textSize.y);
                        event.gc.drawRectangle(x, event.y + 2, textSize.x - 1, textSize.y - 1);
                        x += textSize.x + 4;
                    }
                }
            }
        });
        this.attributeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSettingsDialog.this.updateAttributeSelection();
            }
        });
    }

    private void updateAttributeSelection() {
        TableItem[] selection = this.attributeTable.getSelection();
        this.attribute = selection.length == 0 ? null : (DBDAttributeBinding)selection[0].getData();
        this.colorsTable.removeAll();
        if (this.attribute == null) {
            this.curOverride = null;
            this.colorOverrides = null;
        } else {
            this.colorOverrides = this.vEntity.getColorOverrides(this.attribute.getName());
            if (this.colorOverrides == null) {
                this.colorOverrides = new ArrayList<DBVColorOverride>();
            }
            for (DBVColorOverride co : this.colorOverrides) {
                TableItem tableItem = new TableItem(this.colorsTable, 0);
                tableItem.setData((Object)co);
                this.updateColorItem(tableItem);
            }
            if (!this.colorOverrides.isEmpty()) {
                this.curOverride = this.colorOverrides.get(0);
                this.colorsTable.setSelection(0);
            } else {
                this.curOverride = null;
            }
        }
        this.updateControlsState();
    }

    private void createAttributeSettingsArea(Composite composite) {
        Composite mainGroup = UIUtils.createComposite((Composite)composite, (int)1);
        mainGroup.setLayoutData((Object)new GridData(1810));
        Composite colorsGroup = UIUtils.createComposite((Composite)mainGroup, (int)2);
        colorsGroup.setLayoutData((Object)new GridData(1810));
        this.colorsTable = new Table(colorsGroup, 67584);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        this.colorsTable.setLayoutData((Object)gd);
        this.colorsTable.addListener(40, event -> {
            if ((event.detail & 2) != 0) {
                Color bgColor = this.getColorTableBackground((DBVColorOverride)event.item.getData());
                if (bgColor != null) {
                    event.gc.setBackground(bgColor);
                } else {
                    event.gc.setBackground(this.colorsTable.getBackground());
                }
                event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                event.gc.drawRectangle(event.x, event.y, event.width - 1, event.height - 1);
            }
        });
        UIUtils.createTableColumn((Table)this.colorsTable, (int)131072, (String)"Value(s)");
        UIUtils.executeOnResize((Control)this.colorsTable, () -> UIUtils.packColumns((Table)this.colorsTable, (boolean)true));
        this.colorsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ColorSettingsDialog.this.colorsTable.getSelectionIndex();
                ColorSettingsDialog.this.curOverride = selectionIndex < 0 ? null : (DBVColorOverride)ColorSettingsDialog.this.colorsTable.getItem(selectionIndex).getData();
                ColorSettingsDialog.this.btnDelete.setEnabled(selectionIndex >= 0);
                ColorSettingsDialog.this.updateControlsState();
            }
        });
        ToolBar buttonsPanel = new ToolBar(colorsGroup, 0x800200);
        buttonsPanel.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsPanel, (String)"Add", (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSettingsDialog.this.curOverride = new DBVColorOverride(ColorSettingsDialog.this.attribute.getName(), DBCLogicalOperator.EQUALS, null, null, null);
                ColorSettingsDialog.this.vEntity.addColorOverride(ColorSettingsDialog.this.curOverride);
                TableItem tableItem = new TableItem(ColorSettingsDialog.this.colorsTable, 0);
                tableItem.setData((Object)ColorSettingsDialog.this.curOverride);
                ColorSettingsDialog.this.colorsTable.setSelection(tableItem);
                ColorSettingsDialog.this.updateColorItem(tableItem);
                ColorSettingsDialog.this.updateControlsState();
            }
        });
        this.btnDelete = UIUtils.createToolItem((ToolBar)buttonsPanel, (String)"Delete", (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.colorsTable.getItem(ColorSettingsDialog.this.colorsTable.getSelectionIndex()).dispose();
                    ColorSettingsDialog.this.vEntity.removeColorOverride(ColorSettingsDialog.this.curOverride);
                    ColorSettingsDialog.this.curOverride = null;
                    ColorSettingsDialog.this.updateControlsState();
                }
            }
        });
        this.btnDelete.setEnabled(false);
        this.settingsGroup = new Composite(mainGroup, 0);
        this.settingsGroup.setLayoutData((Object)new GridData(770));
        this.settingsGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 3;
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_label).setLayoutData((Object)gd2);
        this.rangeCheck = UIUtils.createCheckbox((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_range_label, (String)ResultSetMessages.dialog_row_colors_group_settings_range_tip, (boolean)false, (int)3);
        this.rangeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.curOverride.setRange(ColorSettingsDialog.this.rangeCheck.getSelection());
                }
                ColorSettingsDialog.this.updateControlsState();
            }
        });
        this.singleColumnCheck = UIUtils.createCheckbox((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_single_column_label, (String)ResultSetMessages.dialog_row_colors_group_settings_single_column_tip, (boolean)false, (int)3);
        this.singleColumnCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.curOverride.setSingleColumn(ColorSettingsDialog.this.singleColumnCheck.getSelection());
                }
            }
        });
        this.operatorCombo = UIUtils.createLabelCombo((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_operator_label, (String)ResultSetMessages.dialog_row_colors_group_settings_operator_tip, (int)12);
        this.operatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.curOverride.setOperator(SUPPORTED_OPERATORS[ColorSettingsDialog.this.operatorCombo.getSelectionIndex()]);
                }
                ColorSettingsDialog.this.updateControlsState();
            }
        });
        UIUtils.createPlaceholder((Composite)this.settingsGroup, (int)1);
        DBCLogicalOperator[] dBCLogicalOperatorArray = SUPPORTED_OPERATORS;
        int n = SUPPORTED_OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            DBCLogicalOperator operator = dBCLogicalOperatorArray[n2];
            this.operatorCombo.add(operator.getExpression());
            ++n2;
        }
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_value_label);
        this.editorPlaceholder1 = new Composite(this.settingsGroup, 0);
        this.editorPlaceholder1.setLayoutData((Object)new GridData(768));
        this.editorPlaceholder1.setLayout((Layout)new FillLayout());
        this.editorPlaceholder2 = new Composite(this.settingsGroup, 0);
        this.editorPlaceholder2.setLayoutData((Object)new GridData(768));
        this.editorPlaceholder2.setLayout((Layout)new FillLayout());
        this.valueEditor1 = this.createValueEditor(this.editorPlaceholder1, 0);
        this.valueEditor2 = this.createValueEditor(this.editorPlaceholder2, 1);
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_background_color_label);
        this.bgColorSelector1 = new ColorSelector(this.settingsGroup);
        this.bgColorSelector1.addListener(event -> {
            this.curOverride.setColorBackground(StringConverter.asString((RGB)this.bgColorSelector1.getColorValue()));
            this.updateCurrentTreeItem();
        });
        this.bgColorSelector2 = new ColorSelector(this.settingsGroup);
        this.bgColorSelector2.addListener(event -> {
            this.curOverride.setColorBackground2(StringConverter.asString((RGB)this.bgColorSelector2.getColorValue()));
            this.updateCurrentTreeItem();
        });
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_foreground_color_label);
        this.fgColorSelector1 = new ColorSelector(this.settingsGroup);
        this.fgColorSelector1.addListener(event -> {
            this.curOverride.setColorForeground(StringConverter.asString((RGB)this.fgColorSelector1.getColorValue()));
            this.updateCurrentTreeItem();
        });
        this.fgColorSelector2 = new ColorSelector(this.settingsGroup);
        this.fgColorSelector2.addListener(event -> {
            this.curOverride.setColorForeground2(StringConverter.asString((RGB)this.fgColorSelector2.getColorValue()));
            this.updateCurrentTreeItem();
        });
        UIUtils.createInfoLabel((Composite)this.settingsGroup, (String)ResultSetMessages.dialog_row_colors_group_settings_tip, (int)768, (int)3);
    }

    private void updateSettingsValues() {
        try {
            if (this.curOverride == null) {
                UIUtils.disposeChildControls((Composite)this.editorPlaceholder1);
                new Text(this.editorPlaceholder1, 2048);
                UIUtils.disposeChildControls((Composite)this.editorPlaceholder2);
                new Text(this.editorPlaceholder2, 2048);
                this.valueEditor1 = null;
                this.valueEditor2 = null;
                this.operatorCombo.select(0);
                this.rangeCheck.setSelection(false);
                this.singleColumnCheck.setSelection(false);
                this.bgColorSelector1.setColorValue(DEFAULT_RGB);
                this.fgColorSelector1.setColorValue(DEFAULT_RGB);
                this.bgColorSelector2.setColorValue(DEFAULT_RGB);
                this.fgColorSelector2.setColorValue(DEFAULT_RGB);
            } else {
                this.operatorCombo.select(Math.max(ArrayUtils.indexOf((Object[])SUPPORTED_OPERATORS, (Object)this.curOverride.getOperator()), 0));
                this.rangeCheck.setSelection(this.curOverride.isRange());
                this.singleColumnCheck.setSelection(this.curOverride.isSingleColumn());
                this.valueEditor1 = this.createValueEditor(this.editorPlaceholder1, 0);
                this.valueEditor2 = this.createValueEditor(this.editorPlaceholder2, 1);
                Object[] values = this.curOverride.getAttributeValues();
                if (this.valueEditor1 != null) {
                    this.valueEditor1.primeEditorValue(ArrayUtils.isEmpty((Object[])values) ? null : values[0]);
                }
                if (!CommonUtils.isEmpty((String)this.curOverride.getColorBackground())) {
                    this.bgColorSelector1.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorBackground()));
                } else {
                    this.bgColorSelector1.setColorValue(DEFAULT_RGB);
                }
                if (!CommonUtils.isEmpty((String)this.curOverride.getColorForeground())) {
                    this.fgColorSelector1.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorForeground()));
                } else {
                    this.fgColorSelector1.setColorValue(DEFAULT_RGB);
                }
                if (this.curOverride.isRange()) {
                    if (this.valueEditor2 != null) {
                        this.valueEditor2.primeEditorValue(ArrayUtils.isEmpty((Object[])values) || values.length < 2 ? null : values[1]);
                    }
                    if (!CommonUtils.isEmpty((String)this.curOverride.getColorBackground2())) {
                        this.bgColorSelector2.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorBackground2()));
                    } else {
                        this.bgColorSelector2.setColorValue(DEFAULT_RGB);
                    }
                    if (!CommonUtils.isEmpty((String)this.curOverride.getColorForeground2())) {
                        this.fgColorSelector2.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorForeground2()));
                    } else {
                        this.fgColorSelector2.setColorValue(DEFAULT_RGB);
                    }
                }
            }
            this.settingsGroup.layout(true, true);
            this.updateCurrentTreeItem();
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    private void updateControlsState() {
        if (this.curOverride == null) {
            if (this.settingsEnableState == null) {
                this.settingsEnableState = ControlEnableState.disable((Control)this.settingsGroup);
            }
        } else if (this.settingsEnableState != null) {
            this.settingsEnableState.restore();
            this.settingsEnableState = null;
        }
        this.updateSettingsValues();
        boolean isRange = this.rangeCheck.getSelection();
        if (this.valueEditor2 != null) {
            this.valueEditor2.getControl().setEnabled(isRange);
        }
        this.bgColorSelector2.setEnabled(isRange);
        this.fgColorSelector2.setEnabled(isRange);
        this.operatorCombo.setEnabled(!isRange);
        this.colorsTable.setEnabled(this.attribute != null);
        this.btnDelete.setEnabled(this.colorsTable.getSelectionIndex() >= 0);
    }

    private IValueEditor createValueEditor(Composite editorPlaceholder, final int index) {
        try {
            UIUtils.disposeChildControls((Composite)editorPlaceholder);
            IValueManager valueManager = ValueManagerRegistry.findValueManager(this.resultSetViewer.getDataSource(), (DBSTypedObject)this.attribute, this.attribute.getValueHandler().getValueObjectType((DBSTypedObject)this.attribute));
            ColorValueController valueController = new ColorValueController(this, this.settingsGroup){

                @Override
                public Object getValue() {
                    if (curOverride == null) {
                        return null;
                    }
                    Object[] attributeValues = curOverride.getAttributeValues();
                    if (attributeValues == null || index > attributeValues.length - 1) {
                        return null;
                    }
                    return attributeValues[index];
                }
            };
            valueController.setInlinePlaceholder(editorPlaceholder);
            IValueEditor editor = valueManager.createEditor(valueController);
            if (editor == null) {
                Label errorLabel = new Label(editorPlaceholder, 0);
                errorLabel.setText("N/A");
            } else {
                editor.createControl();
                editor.getControl().addListener(24, event -> {
                    if (this.curOverride != null) {
                        try {
                            Object value = editor.extractEditorValue();
                            Object[] attributeValues = this.curOverride.getAttributeValues();
                            int valueCount = index + 1;
                            if (attributeValues == null) {
                                attributeValues = new Object[valueCount];
                            } else if (attributeValues.length != valueCount) {
                                attributeValues = Arrays.copyOf(attributeValues, valueCount);
                            }
                            attributeValues[n] = value;
                            this.curOverride.setAttributeValues(attributeValues);
                            this.updateCurrentTreeItem();
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                });
            }
            return editor;
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private void updateCurrentTreeItem() {
        int itemIndex = this.colorsTable.getSelectionIndex();
        if (itemIndex >= 0) {
            this.updateColorItem(this.colorsTable.getItem(itemIndex));
        }
        this.attributeTable.redraw();
    }

    private void updateColorItem(TableItem tableItem) {
        DBVColorOverride co = (DBVColorOverride)tableItem.getData();
        Object[] values = co.getAttributeValues();
        String text = ArrayUtils.isEmpty((Object[])values) ? String.valueOf(co.getOperator().getExpression()) + " ?" : (values.length == 1 ? String.valueOf(co.getOperator().getExpression()) + " " + DBValueFormatting.getDefaultValueDisplayString((Object)values[0], (DBDDisplayFormat)DBDDisplayFormat.UI) : (co.isRange() ? "In " + Arrays.toString(values) : String.valueOf(co.getOperator().getExpression()) + " " + Arrays.toString(values)));
        tableItem.setText(0, text);
        tableItem.setForeground(this.getColorTableForeground((DBVColorOverride)tableItem.getData()));
        tableItem.setBackground(this.getColorTableBackground((DBVColorOverride)tableItem.getData()));
    }

    private Color getColorTableForeground(DBVColorOverride co) {
        if (!CommonUtils.isEmpty((String)co.getColorForeground())) {
            return UIUtils.getSharedColor((String)co.getColorForeground());
        }
        return null;
    }

    private Color getColorTableBackground(DBVColorOverride co) {
        if (!co.isRange()) {
            if (!CommonUtils.isEmpty((String)co.getColorBackground())) {
                return UIUtils.getSharedColor((String)co.getColorBackground());
            }
        } else {
            String bg1 = co.getColorBackground();
            String bg2 = co.getColorBackground2();
            if (!CommonUtils.isEmpty((String)bg1) && !CommonUtils.isEmpty((String)bg2)) {
                Color bg1Color = UIUtils.getSharedColor((String)bg1);
                Color bg2Color = UIUtils.getSharedColor((String)bg2);
                return UIUtils.getSharedColor((RGB)ResultSetUtils.makeGradientValue(bg1Color.getRGB(), bg2Color.getRGB(), 1.0, 100.0, 50.0));
            }
        }
        return null;
    }

    public int open() {
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.vEntitySrc.copyFrom(this.vEntity, this.vEntity.getModel());
        this.vEntitySrc.persistConfiguration();
        this.resultSetViewer.getModel().updateColorMapping(true);
        super.okPressed();
    }

    public boolean close() {
        if (this.vEntity != null) {
            this.vEntity.dispose();
        }
        return super.close();
    }

    private class ColorValueController
    extends ResultSetValueController {
        ColorValueController(Composite inlinePlaceholder) {
            super(ColorSettingsDialog.this.resultSetViewer, ColorSettingsDialog.this.attribute, null, IValueController.EditType.INLINE, inlinePlaceholder);
        }

        void setInlinePlaceholder(Composite ph) {
            this.inlinePlaceholder = ph;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public void updateValue(@Nullable Object value, boolean updatePresentation) {
        }
    }
}

