/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class EntityRemoveCommand
extends Command {
    private EntityPart entityPart;
    private DiagramPart diagramPart;
    private ERDEntity entity;
    private int index = -1;
    private List<ERDAssociation> foreignKeyRelationships = new ArrayList<ERDAssociation>();
    private List<ERDAssociation> primaryKeyRelationships = new ArrayList<ERDAssociation>();

    public EntityRemoveCommand(EntityPart entityPart) {
        this.entityPart = entityPart;
        this.diagramPart = entityPart.getDiagramPart();
        this.entity = entityPart.getEntity();
    }

    public EntityPart getEntityPart() {
        return this.entityPart;
    }

    public ERDEntity getEntity() {
        return this.entity;
    }

    private void deleteRelationships(ERDEntity t) {
        this.foreignKeyRelationships.addAll(t.getAssociations());
        for (ERDAssociation association : this.foreignKeyRelationships) {
            association.getTargetEntity().removeReferenceAssociation(association, true);
            t.removeAssociation(association, true);
        }
        this.primaryKeyRelationships.addAll(t.getReferences());
        for (ERDAssociation r : this.primaryKeyRelationships) {
            r.getSourceEntity().removeAssociation(r, true);
            t.removeReferenceAssociation(r, true);
        }
    }

    public void execute() {
        this.primExecute();
    }

    private void primExecute() {
        this.diagramPart.getDiagram().getVisualInfo((DBSEntity)((DBSEntity)this.entity.getObject()), (boolean)true).initBounds = this.entityPart.getBounds();
        this.deleteRelationships(this.entity);
        this.index = this.diagramPart.getDiagram().getEntities().indexOf(this.entity);
        this.diagramPart.getDiagram().removeEntity(this.entity, true);
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreRelationships() {
        for (ERDAssociation r : this.foreignKeyRelationships) {
            r.getSourceEntity().addAssociation(r, true);
            r.getTargetEntity().addReferenceAssociation(r, true);
        }
        this.foreignKeyRelationships.clear();
        for (ERDAssociation r : this.primaryKeyRelationships) {
            r.getSourceEntity().addAssociation(r, true);
            r.getTargetEntity().addReferenceAssociation(r, true);
        }
        this.primaryKeyRelationships.clear();
    }

    public void undo() {
        this.diagramPart.getDiagram().addEntity(this.entity, this.index, true);
        this.restoreRelationships();
    }
}

