/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data.type;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.dbeaver.model.gis.DBGeometryDimension;
import org.jkiss.utils.CommonUtils;

public class PostgreGeometryTypeHandler
extends PostgreTypeHandler {
    public static final PostgreGeometryTypeHandler INSTANCE = new PostgreGeometryTypeHandler();
    private static final int GEOMETRY_TYPE_GEOMETRY = 0;
    private static final int GEOMETRY_TYPE_POINT = 4;
    private static final int GEOMETRY_TYPE_LINESTRING = 8;
    private static final int GEOMETRY_TYPE_POLYGON = 12;
    private static final int GEOMETRY_TYPE_MULTIPOINT = 16;
    private static final int GEOMETRY_TYPE_MULTILINESTRING = 20;
    private static final int GEOMETRY_TYPE_MULTIPOLYGON = 24;
    private static final int GEOMETRY_DIMENSION_M = 1;
    private static final int GEOMETRY_DIMENSION_Z = 2;
    private static final int GEOMETRY_DIMENSION_ZM = 3;
    private static final int GEOMETRY_MASK_TYPE = 252;
    private static final int GEOMETRY_MASK_SRID = 0xFFFF00;
    private static final int GEOMETRY_MASK_DIMENSION = 3;
    private static final String GEOMETRY_NAME_GEOMETRY = "geometry";
    private static final String GEOMETRY_NAME_POINT = "point";
    private static final String GEOMETRY_NAME_LINESTRING = "linestring";
    private static final String GEOMETRY_NAME_POLYGON = "polygon";
    private static final String GEOMETRY_NAME_MULTIPOINT = "multipoint";
    private static final String GEOMETRY_NAME_MULTILINESTRING = "multilinestring";
    private static final String GEOMETRY_NAME_MULTIPOLYGON = "multipolygon";

    private PostgreGeometryTypeHandler() {
    }

    @Override
    public int getTypeModifiers(@NotNull PostgreDataType type, @NotNull String typeName, @NotNull String[] typmod) throws DBException {
        switch (typmod.length) {
            case 0: {
                return -1;
            }
            case 1: {
                return PostgreGeometryTypeHandler.getGeometryModifiers(typmod[0].toLowerCase(), 0);
            }
            case 2: {
                return PostgreGeometryTypeHandler.getGeometryModifiers(typmod[0].toLowerCase(), CommonUtils.toInt((Object)typmod[1]));
            }
        }
        return super.getTypeModifiers(type, typeName, typmod);
    }

    @Override
    @NotNull
    public String getTypeModifiersString(@NotNull PostgreDataType type, int typmod) {
        StringBuilder sb = new StringBuilder();
        if (typmod >= 0) {
            int srid;
            sb.append('(').append(PostgreGeometryTypeHandler.getGeometryType(typmod));
            DBGeometryDimension dimension = PostgreGeometryTypeHandler.getGeometryDimension(typmod);
            if (dimension.hasZ()) {
                sb.append('z');
            }
            if (dimension.hasM()) {
                sb.append('m');
            }
            if ((srid = PostgreGeometryTypeHandler.getGeometrySRID(typmod)) > 0) {
                sb.append(", ").append(srid);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Nullable
    public static String getGeometryType(int typmod) {
        if (typmod < 0) {
            return null;
        }
        switch (typmod & 0xFC) {
            case 0: {
                return GEOMETRY_NAME_GEOMETRY;
            }
            case 4: {
                return GEOMETRY_NAME_POINT;
            }
            case 8: {
                return GEOMETRY_NAME_LINESTRING;
            }
            case 12: {
                return GEOMETRY_NAME_POLYGON;
            }
            case 16: {
                return GEOMETRY_NAME_MULTIPOINT;
            }
            case 20: {
                return GEOMETRY_NAME_MULTILINESTRING;
            }
            case 24: {
                return GEOMETRY_NAME_MULTIPOLYGON;
            }
        }
        throw new IllegalArgumentException("Error obtaining geometry type from typmod: " + Integer.toHexString(typmod));
    }

    @NotNull
    public static DBGeometryDimension getGeometryDimension(int typmod) {
        switch (typmod & 3) {
            case 1: {
                return DBGeometryDimension.XYM;
            }
            case 2: {
                return DBGeometryDimension.XYZ;
            }
            case 3: {
                return DBGeometryDimension.XYZM;
            }
        }
        return DBGeometryDimension.XY;
    }

    public static int getGeometrySRID(int typmod) {
        return (typmod & 0xFFFF00) >> 8;
    }

    private static int getGeometryModifiers(@NotNull String name, int srid) throws DBException {
        int typmod = (srid & 0xFFFF) << 8;
        if (name.endsWith("zm")) {
            typmod |= 3;
            name = name.substring(0, name.length() - 2);
        } else if (name.endsWith("z")) {
            typmod |= 2;
            name = name.substring(0, name.length() - 1);
        } else if (name.endsWith("m")) {
            typmod |= 1;
            name = name.substring(0, name.length() - 1);
        }
        switch (name) {
            case "geometry": {
                typmod |= 0;
                break;
            }
            case "point": {
                typmod |= 4;
                break;
            }
            case "linestring": {
                typmod |= 8;
                break;
            }
            case "polygon": {
                typmod |= 0xC;
                break;
            }
            case "multipoint": {
                typmod |= 0x10;
                break;
            }
            case "multilinestring": {
                typmod |= 0x14;
                break;
            }
            case "multipolygon": {
                typmod |= 0x18;
                break;
            }
            default: {
                throw new DBException("Unsupported geometry type: '" + name + "'");
            }
        }
        return typmod;
    }
}

