/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.IElementFilter;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class AuthModelSelector
extends Composite {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private IElementFilter<DBPAuthModelDescriptor> modelFilter;
    private IElementFilter<DBPAuthModelDescriptor> modelChangeFilter;
    private List<? extends DBPAuthModelDescriptor> allAuthModels;
    private DBPDataSourceContainer activeDataSource;
    private DBPAuthModelDescriptor selectedAuthModel;
    private Composite modelConfigPlaceholder;
    private IObjectPropertyConfigurator<DBPDataSourceContainer> authModelConfigurator;
    private Runnable changeListener;
    private Combo authModelCombo;

    public AuthModelSelector(Composite parent, Runnable changeListener) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.changeListener = changeListener;
        this.modelConfigPlaceholder = UIUtils.createControlGroup((Composite)this, (String)UIConnectionMessages.dialog_connection_auth_group, (int)2, (int)768, (int)0);
    }

    public DBPAuthModelDescriptor getSelectedAuthModel() {
        return this.selectedAuthModel;
    }

    Composite getAuthPanelComposite() {
        return this.modelConfigPlaceholder;
    }

    public void setModelFiler(IElementFilter<DBPAuthModelDescriptor> filter) {
        this.modelFilter = filter;
    }

    public void setModelChangeFilter(IElementFilter<DBPAuthModelDescriptor> modelChangeFilter) {
        this.modelChangeFilter = modelChangeFilter;
    }

    public void clearSettings() {
        UIUtils.disposeChildControls((Composite)this.modelConfigPlaceholder);
    }

    public void loadSettings(DBPDataSourceContainer dataSourceContainer, DBPAuthModelDescriptor activeAuthModel, String defaultAuthModelId) {
        this.activeDataSource = dataSourceContainer;
        this.selectedAuthModel = activeAuthModel;
        this.allAuthModels = this.activeDataSource.getDriver() == DriverDescriptor.NULL_DRIVER ? DataSourceProviderRegistry.getInstance().getAllAuthModels() : DataSourceProviderRegistry.getInstance().getApplicableAuthModels(this.activeDataSource.getDriver());
        this.allAuthModels.removeIf(o -> this.modelFilter != null && !this.modelFilter.isValidElement(o));
        this.allAuthModels.sort((o1, o2) -> "native".equals(o1.getId()) ? -1 : ("native".equals(o2.getId()) ? 1 : o1.getName().compareTo(o2.getName())));
        if (this.selectedAuthModel == null && !CommonUtils.isEmpty((String)defaultAuthModelId)) {
            for (DBPAuthModelDescriptor dBPAuthModelDescriptor : this.allAuthModels) {
                if (!dBPAuthModelDescriptor.getId().equals(defaultAuthModelId)) continue;
                this.selectedAuthModel = dBPAuthModelDescriptor;
                dataSourceContainer.getConnectionConfiguration().setAuthModelId(this.selectedAuthModel.getId());
                break;
            }
            if (this.selectedAuthModel == null) {
                this.selectedAuthModel = this.allAuthModels.get(0);
                dataSourceContainer.getConnectionConfiguration().setAuthModelId(this.selectedAuthModel.getId());
            }
        }
        this.changeAuthModel();
        boolean bl = !"local".equals(this.activeDataSource.getOrigin().getType());
        this.authModelCombo.setEnabled(!bl);
    }

    private void changeAuthModel() {
        this.showAuthModelSettings();
    }

    protected void showAuthModelSettings() {
        Composite parentFolder = (Composite)UIUtils.getParentOfType((Control)this.modelConfigPlaceholder, TabFolder.class);
        if (parentFolder == null) {
            parentFolder = (Composite)UIUtils.getParentOfType((Control)this.modelConfigPlaceholder, Shell.class);
        }
        this.modelConfigPlaceholder.setRedraw(false);
        UIUtils.disposeChildControls((Composite)this.modelConfigPlaceholder);
        Label authModelLabel = UIUtils.createControlLabel((Composite)this.modelConfigPlaceholder, (String)UIConnectionMessages.dialog_connection_auth_group);
        Composite authModelComp = UIUtils.createComposite((Composite)this.modelConfigPlaceholder, (int)2);
        authModelComp.setLayoutData((Object)new GridData(768));
        this.authModelCombo = new Combo(authModelComp, 12);
        this.authModelCombo.setLayoutData((Object)new GridData(32));
        this.authModelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Unable to fully structure code
             */
            public void widgetSelected(SelectionEvent e) {
                block3: {
                    try {
                        newAuthModel = (DBPAuthModelDescriptor)AuthModelSelector.access$2(AuthModelSelector.this).get(AuthModelSelector.access$0(AuthModelSelector.this).getSelectionIndex());
                        if (AuthModelSelector.access$1(AuthModelSelector.this) == newAuthModel) ** GOTO lbl16
                        if (AuthModelSelector.access$3(AuthModelSelector.this) == null || AuthModelSelector.access$3(AuthModelSelector.this).isValidElement((Object)newAuthModel)) break block3;
                        AuthModelSelector.access$0(AuthModelSelector.this).select(AuthModelSelector.access$2(AuthModelSelector.this).indexOf(AuthModelSelector.access$1(AuthModelSelector.this)));
                    }
                    catch (Throwable var3_3) {
                        AuthModelSelector.access$0(AuthModelSelector.this).setToolTipText(AuthModelSelector.access$1(AuthModelSelector.this) == null ? "" : CommonUtils.notEmpty((String)AuthModelSelector.access$1(AuthModelSelector.this).getDescription()));
                        throw var3_3;
                    }
                    AuthModelSelector.access$0(AuthModelSelector.this).setToolTipText(AuthModelSelector.access$1(AuthModelSelector.this) == null ? "" : CommonUtils.notEmpty((String)AuthModelSelector.access$1(AuthModelSelector.this).getDescription()));
                    return;
                }
                AuthModelSelector.access$4(AuthModelSelector.this, newAuthModel);
                AuthModelSelector.access$5(AuthModelSelector.this).getConnectionConfiguration().setAuthModelId(AuthModelSelector.access$1(AuthModelSelector.this).getId());
                AuthModelSelector.this.showAuthModelSettings();
lbl16:
                // 2 sources

                AuthModelSelector.access$6(AuthModelSelector.this).setFocus();
                AuthModelSelector.access$7(AuthModelSelector.this).run();
                AuthModelSelector.access$0(AuthModelSelector.this).setToolTipText(AuthModelSelector.access$1(AuthModelSelector.this) == null ? "" : CommonUtils.notEmpty((String)AuthModelSelector.access$1(AuthModelSelector.this).getDescription()));
            }
        });
        Label authModelDescLabel = new Label(authModelComp, 0);
        authModelDescLabel.setLayoutData((Object)new GridData(768));
        for (DBPAuthModelDescriptor dBPAuthModelDescriptor : this.allAuthModels) {
            this.authModelCombo.add(dBPAuthModelDescriptor.getName());
        }
        if (this.selectedAuthModel != null) {
            this.authModelCombo.select(this.allAuthModels.indexOf(this.selectedAuthModel));
            this.authModelCombo.setToolTipText(CommonUtils.notEmpty((String)this.selectedAuthModel.getDescription()));
        }
        boolean bl = this.allAuthModels.size() >= 2;
        UIUtils.setControlVisible((Control)authModelLabel, (boolean)bl);
        UIUtils.setControlVisible((Control)authModelComp, (boolean)bl);
        ((Group)this.modelConfigPlaceholder).setText(bl ? UIConnectionMessages.dialog_connection_auth_group : String.valueOf(UIConnectionMessages.dialog_connection_auth_group) + " (" + this.selectedAuthModel.getName() + ")");
        this.authModelConfigurator = null;
        UIPropertyConfiguratorDescriptor uiConfiguratorDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.selectedAuthModel.getImplClassName());
        if (uiConfiguratorDescriptor != null) {
            try {
                this.authModelConfigurator = uiConfiguratorDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        } else {
            log.debug((Object)("No UI configurator for auth model " + this.selectedAuthModel.getId()));
        }
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.createControl(this.modelConfigPlaceholder, () -> this.changeListener.run());
            if (this.activeDataSource != null && this.selectedAuthModel != null) {
                this.activeDataSource.getConnectionConfiguration().setAuthModelId(this.selectedAuthModel.getId());
            }
            this.authModelConfigurator.loadSettings((Object)this.activeDataSource);
        } else if (this.selectedAuthModel != null && !CommonUtils.isEmpty((String)this.selectedAuthModel.getDescription())) {
            Label descLabel = new Label(this.modelConfigPlaceholder, 0);
            descLabel.setText(this.selectedAuthModel.getDescription());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            descLabel.setLayoutData((Object)gd);
        }
        this.modelConfigPlaceholder.setRedraw(true);
        if (this.modelConfigPlaceholder.getSize().x > 0 && parentFolder != null) {
            parentFolder.layout(true, true);
        }
    }

    public boolean isComplete() {
        return this.authModelConfigurator == null || this.authModelConfigurator.isComplete();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.saveSettings((Object)dataSource);
        }
    }

    static /* synthetic */ Combo access$0(AuthModelSelector authModelSelector) {
        return authModelSelector.authModelCombo;
    }

    static /* synthetic */ DBPAuthModelDescriptor access$1(AuthModelSelector authModelSelector) {
        return authModelSelector.selectedAuthModel;
    }

    static /* synthetic */ List access$2(AuthModelSelector authModelSelector) {
        return authModelSelector.allAuthModels;
    }

    static /* synthetic */ IElementFilter access$3(AuthModelSelector authModelSelector) {
        return authModelSelector.modelChangeFilter;
    }

    static /* synthetic */ void access$4(AuthModelSelector authModelSelector, DBPAuthModelDescriptor dBPAuthModelDescriptor) {
        authModelSelector.selectedAuthModel = dBPAuthModelDescriptor;
    }

    static /* synthetic */ DBPDataSourceContainer access$5(AuthModelSelector authModelSelector) {
        return authModelSelector.activeDataSource;
    }

    static /* synthetic */ Composite access$6(AuthModelSelector authModelSelector) {
        return authModelSelector.modelConfigPlaceholder;
    }

    static /* synthetic */ Runnable access$7(AuthModelSelector authModelSelector) {
        return authModelSelector.changeListener;
    }
}

