/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSelectItem;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class SQLQuery
implements SQLScriptElement {
    private static final Pattern QUERY_TITLE_PATTERN = Pattern.compile("^\\s*(?:--|//|/\\*)\\s*(?:name|title)\\s*:\\s*(.+)$", 10);
    @Nullable
    private final DBPDataSource dataSource;
    @NotNull
    private String originalText;
    @NotNull
    private String text;
    private int offset;
    private int length;
    private Object data;
    private int resultsOffset = -1;
    private int resultsMaxRows = -1;
    @Nullable
    private List<SQLQueryParameter> parameters;
    private Throwable parseError;
    private boolean parsed = false;
    @NotNull
    private SQLQueryType type;
    private Statement statement;
    private SingleTableMeta singleTableMeta;
    private List<SQLSelectItem> selectItems;
    private String queryTitle;

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text) {
        this(dataSource, text, 0, text.length());
    }

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text, @NotNull SQLQuery sourceQuery) {
        this(dataSource, text, sourceQuery, true);
    }

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text, @NotNull SQLQuery sourceQuery, boolean preserveOriginal) {
        this(dataSource, text, sourceQuery.offset, sourceQuery.length);
        if (preserveOriginal) {
            this.originalText = sourceQuery.originalText;
        }
        this.parameters = sourceQuery.parameters;
        this.data = sourceQuery.data;
    }

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text, int offset, int length) {
        this.dataSource = dataSource;
        this.originalText = this.text = text;
        this.offset = offset;
        this.length = length;
        this.type = SQLQueryType.UNKNOWN;
        this.queryTitle = null;
        Matcher matcher = QUERY_TITLE_PATTERN.matcher(text);
        if (matcher.find()) {
            this.queryTitle = matcher.group(1).trim();
        }
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    private void parseQuery() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        try {
            if (CommonUtils.isEmpty((String)this.text)) {
                this.statement = null;
                this.parseError = new DBException("Empty query");
                return;
            }
            this.statement = SQLSemanticProcessor.parseQuery(this.dataSource == null ? null : this.dataSource.getSQLDialect(), this.text);
            if (this.statement instanceof Select) {
                this.type = SQLQueryType.SELECT;
                SelectBody selectBody = ((Select)this.statement).getSelectBody();
                if (selectBody instanceof PlainSelect) {
                    List items;
                    PlainSelect plainSelect = (PlainSelect)selectBody;
                    FromItem fromItem = plainSelect.getFromItem();
                    if (fromItem instanceof SubSelect && this.isPotentiallySingleSourceSelect(plainSelect) && ((SubSelect)fromItem).getSelectBody() instanceof PlainSelect && this.isPotentiallySingleSourceSelect((PlainSelect)((SubSelect)fromItem).getSelectBody())) {
                        plainSelect = (PlainSelect)((SubSelect)fromItem).getSelectBody();
                        fromItem = plainSelect.getFromItem();
                    }
                    if (fromItem instanceof Table && this.isPotentiallySingleSourceSelect(plainSelect)) {
                        boolean hasSubSelects = false;
                        boolean hasDirectSelects = false;
                        for (SelectItem si : plainSelect.getSelectItems()) {
                            if (si instanceof SelectExpressionItem && ((SelectExpressionItem)si).getExpression() instanceof SubSelect) {
                                hasSubSelects = true;
                                continue;
                            }
                            if (!(si instanceof SelectExpressionItem) || !(((SelectExpressionItem)si).getExpression() instanceof Column)) continue;
                            hasDirectSelects = true;
                        }
                        if (hasDirectSelects || !hasSubSelects) {
                            this.fillSingleSource((Table)fromItem);
                        }
                    }
                    if ((items = plainSelect.getSelectItems()) != null && !items.isEmpty()) {
                        this.selectItems = new ArrayList<SQLSelectItem>();
                        for (SelectItem item : items) {
                            this.selectItems.add(new SQLSelectItem(item));
                        }
                    }
                }
            } else if (this.statement instanceof Insert) {
                this.type = SQLQueryType.INSERT;
                this.fillSingleSource(((Insert)this.statement).getTable());
            } else if (this.statement instanceof Update) {
                this.type = SQLQueryType.UPDATE;
                Table table = ((Update)this.statement).getTable();
                if (table != null) {
                    this.fillSingleSource(table);
                }
            } else if (this.statement instanceof Delete) {
                this.type = SQLQueryType.DELETE;
                if (((Delete)this.statement).getTable() != null) {
                    this.fillSingleSource(((Delete)this.statement).getTable());
                } else {
                    List tables = ((Delete)this.statement).getTables();
                    if (tables != null && tables.size() == 1) {
                        this.fillSingleSource((Table)tables.get(0));
                    }
                }
            } else {
                this.type = this.statement instanceof Alter || this.statement instanceof CreateTable || this.statement instanceof CreateView || this.statement instanceof Drop || this.statement instanceof CreateIndex ? SQLQueryType.DDL : (this.statement instanceof Merge ? SQLQueryType.MERGE : SQLQueryType.UNKNOWN);
            }
        }
        catch (Throwable e) {
            this.type = SQLQueryType.UNKNOWN;
            this.parseError = e;
        }
    }

    private boolean isPotentiallySingleSourceSelect(PlainSelect plainSelect) {
        return CommonUtils.isEmpty((Collection)plainSelect.getJoins()) && (plainSelect.getGroupBy() == null || CommonUtils.isEmpty((Collection)plainSelect.getGroupBy().getGroupByExpressions())) && CommonUtils.isEmpty((Collection)plainSelect.getIntoTables());
    }

    private void fillSingleSource(Table fromItem) {
        Database database = fromItem.getDatabase();
        String catalogName = database == null ? null : database.getDatabaseName();
        String schemaName = fromItem.getSchemaName();
        String tableName = fromItem.getName();
        this.singleTableMeta = new SingleTableMeta(this.unquoteIdentifier(catalogName), this.unquoteIdentifier(schemaName), this.unquoteIdentifier(tableName));
    }

    private String unquoteIdentifier(String name) {
        if (name == null) {
            return null;
        }
        return this.dataSource == null ? DBUtils.getUnQuotedIdentifier(name, "\"") : DBUtils.getUnQuotedIdentifier(this.dataSource, name);
    }

    public boolean isPlainSelect() {
        this.parseQuery();
        if (this.statement instanceof Select && ((Select)this.statement).getSelectBody() instanceof PlainSelect) {
            PlainSelect selectBody = (PlainSelect)((Select)this.statement).getSelectBody();
            return CommonUtils.isEmpty((Collection)selectBody.getIntoTables()) && selectBody.getLimit() == null && selectBody.getTop() == null && !selectBody.isForUpdate();
        }
        return false;
    }

    public SQLSelectItem getSelectItem(String name) {
        if (this.selectItems == null) {
            return null;
        }
        for (SQLSelectItem item : this.selectItems) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public int getSelectItemCount() {
        return this.selectItems == null ? 0 : this.selectItems.size();
    }

    public SQLSelectItem getSelectItem(int index) {
        return this.selectItems == null || this.selectItems.size() <= index ? null : this.selectItems.get(index);
    }

    @Override
    @NotNull
    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(@NotNull String originalText) {
        this.originalText = originalText;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    public void setText(@NotNull String text) {
        this.text = text;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    @Nullable
    public Statement getStatement() {
        this.parseQuery();
        return this.statement;
    }

    public Throwable getParseError() {
        return this.parseError;
    }

    public List<SQLQueryParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @NotNull
    public SQLQueryType getType() {
        this.parseQuery();
        return this.type;
    }

    public DBCEntityMetaData getSingleSource() {
        this.parseQuery();
        return this.singleTableMeta;
    }

    public void setParameters(List<SQLQueryParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void reset() {
        this.text = this.originalText;
        if (this.parameters != null) {
            this.setParameters(this.parameters);
        }
    }

    public String toString() {
        return this.text;
    }

    public void setResultSetLimit(int rowOffset, int maxRows) {
        this.resultsOffset = rowOffset;
        this.resultsMaxRows = maxRows;
    }

    public int getResultsOffset() {
        return this.resultsOffset;
    }

    public int getResultsMaxRows() {
        return this.resultsMaxRows;
    }

    public boolean isDeleteUpdateDangerous() {
        this.parseQuery();
        if (this.statement == null) {
            return false;
        }
        return this.statement instanceof Delete ? ((Delete)this.statement).getWhere() == null : this.statement instanceof Update && ((Update)this.statement).getWhere() == null;
    }

    public boolean equals(Object obj) {
        return obj instanceof SQLQuery && this.text.equals(((SQLQuery)obj).text);
    }

    private static class SingleTableMeta
    implements DBCEntityMetaData {
        private final String catalogName;
        private final String schemaName;
        private final String tableName;

        private SingleTableMeta(String catalogName, String schemaName, @NotNull String tableName) {
            this.catalogName = catalogName;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        @Override
        @Nullable
        public String getCatalogName() {
            return this.catalogName;
        }

        @Override
        @Nullable
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        @NotNull
        public String getEntityName() {
            return this.tableName;
        }

        @Override
        @NotNull
        public List<? extends DBCAttributeMetaData> getAttributes() {
            return Collections.emptyList();
        }

        public String toString() {
            return DBUtils.getSimpleQualifiedName(this.catalogName, this.schemaName, this.tableName);
        }

        public int hashCode() {
            return (this.catalogName == null ? 1 : this.catalogName.hashCode()) * (this.schemaName == null ? 2 : this.schemaName.hashCode()) * this.tableName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SingleTableMeta)) {
                return false;
            }
            SingleTableMeta md2 = (SingleTableMeta)obj;
            return CommonUtils.equalObjects((Object)this.catalogName, (Object)md2.catalogName) && CommonUtils.equalObjects((Object)this.schemaName, (Object)md2.schemaName) && CommonUtils.equalObjects((Object)this.tableName, (Object)md2.tableName);
        }
    }
}

