/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.auth.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.auth.DBAUserCredentialsProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelDatabaseNative<CREDENTIALS extends AuthModelDatabaseNativeCredentials>
implements DBAAuthModel<CREDENTIALS> {
    public static final String ID = "native";
    public static final AuthModelDatabaseNative INSTANCE = new AuthModelDatabaseNative();

    @Override
    @NotNull
    public CREDENTIALS createCredentials() {
        return (CREDENTIALS)new AuthModelDatabaseNativeCredentials();
    }

    @Override
    @NotNull
    public CREDENTIALS loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        DBAAuthCredentials credentials = this.createCredentials();
        this.loadCredentials(dataSource, configuration, credentials);
        return (CREDENTIALS)credentials;
    }

    protected void loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, CREDENTIALS credentials) {
        DBPDataSourceProvider dataSourceProvider = dataSource.getDriver().getDataSourceProvider();
        if (dataSourceProvider instanceof DBAUserCredentialsProvider) {
            ((AuthModelDatabaseNativeCredentials)credentials).setUserName(((DBAUserCredentialsProvider)((Object)dataSourceProvider)).getConnectionUserName(configuration));
            ((AuthModelDatabaseNativeCredentials)credentials).setUserPassword(((DBAUserCredentialsProvider)((Object)dataSourceProvider)).getConnectionUserPassword(configuration));
        } else {
            ((AuthModelDatabaseNativeCredentials)credentials).setUserName(configuration.getUserName());
            ((AuthModelDatabaseNativeCredentials)credentials).setUserPassword(configuration.getUserPassword());
        }
        boolean allowsEmptyPassword = dataSource.getDriver().isAllowsEmptyPassword();
        if (((AuthModelDatabaseNativeCredentials)credentials).getUserPassword() == null && allowsEmptyPassword) {
            ((AuthModelDatabaseNativeCredentials)credentials).setUserPassword("");
        }
    }

    @Override
    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull CREDENTIALS credentials) {
        configuration.setUserName(((AuthModelDatabaseNativeCredentials)credentials).getUserName());
        configuration.setUserPassword(((AuthModelDatabaseNativeCredentials)credentials).getUserPassword());
    }

    @Override
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, CREDENTIALS credentials, DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        String userName = ((AuthModelDatabaseNativeCredentials)credentials).getUserName();
        String userPassword = ((AuthModelDatabaseNativeCredentials)credentials).getUserPassword();
        if (!CommonUtils.isEmpty((String)userName)) {
            connectProps.put("user", userName);
        }
        if (!CommonUtils.isEmpty((String)userPassword) || dataSource.getContainer().getDriver().isAllowsEmptyPassword() && !CommonUtils.isEmpty((String)userName)) {
            connectProps.put("password", userPassword);
        }
        return credentials;
    }

    @Override
    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }
}

