/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Consumer;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.Node;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.StatementListener;
import net.sf.jsqlparser.parser.StreamProvider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;

public final class CCJSqlParserUtil {
    public static final int ALLOWED_NESTING_DEPTH = 10;

    private CCJSqlParserUtil() {
    }

    public static Statement parse(Reader statementReader) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StreamProvider(statementReader));
        return CCJSqlParserUtil.parseStatement(parser);
    }

    public static Statement parse(String sql) throws JSQLParserException {
        return CCJSqlParserUtil.parse(sql, null);
    }

    public static Statement parse(String sql, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        boolean allowComplexParsing = CCJSqlParserUtil.getNestingDepth(sql) <= 10;
        CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(sql).withAllowComplexParsing(allowComplexParsing);
        if (consumer != null) {
            consumer.accept(parser);
        }
        return CCJSqlParserUtil.parseStatement(parser);
    }

    public static CCJSqlParser newParser(String sql) {
        return new CCJSqlParser(new StringProvider(sql));
    }

    public static CCJSqlParser newParser(InputStream is) throws IOException {
        return new CCJSqlParser(new StreamProvider(is));
    }

    public static CCJSqlParser newParser(InputStream is, String encoding) throws IOException {
        return new CCJSqlParser(new StreamProvider(is, encoding));
    }

    public static Node parseAST(String sql) throws JSQLParserException {
        CCJSqlParser parser = CCJSqlParserUtil.newParser(sql);
        try {
            parser.Statement();
            return parser.jjtree.rootNode();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is);
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is, encoding);
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Expression parseExpression(String expression) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, true);
    }

    public static Expression parseExpression(String expression, boolean allowPartialParse) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, allowPartialParse, p -> {});
    }

    public static Expression parseExpression(String expression, boolean allowPartialParse, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        boolean allowComplexParsing = CCJSqlParserUtil.getNestingDepth(expression) <= 10;
        CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(expression).withAllowComplexParsing(allowComplexParsing);
        if (consumer != null) {
            consumer.accept(parser);
        }
        try {
            Expression expr = parser.SimpleExpression();
            if (!allowPartialParse && parser.getNextToken().kind != 0) {
                throw new JSQLParserException("could only parse partial expression " + expr.toString());
            }
            return expr;
        }
        catch (JSQLParserException ex) {
            throw ex;
        }
        catch (ParseException ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Expression parseCondExpression(String condExpr) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, true);
    }

    public static Expression parseCondExpression(String condExpr, boolean allowPartialParse) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, allowPartialParse, p -> {});
    }

    public static Expression parseCondExpression(String condExpr, boolean allowPartialParse, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        boolean allowComplexParsing = CCJSqlParserUtil.getNestingDepth(condExpr) <= 10;
        CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(condExpr).withAllowComplexParsing(allowComplexParsing);
        if (consumer != null) {
            consumer.accept(parser);
        }
        try {
            Expression expr = parser.Expression();
            if (!allowPartialParse && parser.getNextToken().kind != 0) {
                throw new JSQLParserException("could only parse partial expression " + expr.toString());
            }
            return expr;
        }
        catch (JSQLParserException ex) {
            throw ex;
        }
        catch (ParseException ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parseStatement(CCJSqlParser parser) throws JSQLParserException {
        try {
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statements parseStatements(String sqls) throws JSQLParserException {
        boolean allowComplexParsing = CCJSqlParserUtil.getNestingDepth(sqls) <= 10;
        CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(sqls).withAllowComplexParsing(allowComplexParsing);
        return CCJSqlParserUtil.parseStatements(parser);
    }

    public static Statements parseStatements(CCJSqlParser parser) throws JSQLParserException {
        try {
            return parser.Statements();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static void streamStatements(StatementListener listener, InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is, encoding);
            do {
                Statement stmt = parser.SingleStatement();
                listener.accept(stmt);
                if (parser.getToken((int)1).kind != 250) continue;
                parser.getNextToken();
            } while (parser.getToken((int)1).kind != 0);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static int getNestingDepth(String sql) {
        char[] chars;
        int maxlevel = 0;
        int level = 0;
        block4: for (char c : chars = sql.toCharArray()) {
            switch (c) {
                case '(': {
                    ++level;
                    continue block4;
                }
                case ')': {
                    if (maxlevel < level) {
                        maxlevel = level;
                    }
                    --level;
                    continue block4;
                }
            }
        }
        return maxlevel;
    }
}

