/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data.type;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreGeometryTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreIntervalTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreNumericTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreStringTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTimeTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;

public class PostgreTypeHandlerProvider {
    private PostgreTypeHandlerProvider() {
    }

    @Nullable
    public static PostgreTypeHandler getTypeHandler(@NotNull PostgreDataType type) {
        if (PostgreUtils.isGISDataType(type.getTypeName().toLowerCase())) {
            return PostgreGeometryTypeHandler.INSTANCE;
        }
        switch ((int)type.getObjectId()) {
            case 1700: {
                return PostgreNumericTypeHandler.INSTANCE;
            }
            case 1186: {
                return PostgreIntervalTypeHandler.INSTANCE;
            }
            case 1042: 
            case 1043: 
            case 1560: 
            case 1562: {
                return PostgreStringTypeHandler.INSTANCE;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                return PostgreTimeTypeHandler.INSTANCE;
            }
        }
        return null;
    }
}

