/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class Utilities {
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full/");
    private static final int VALIDATE_EDIT_PROBLEM = 10004;
    public static boolean RUNNING_TESTS = false;
    public static boolean TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE = false;

    public static IWorkbenchPartSite findSite(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof IWorkbenchPart) {
                return ((IWorkbenchPart)data).getSite();
            }
            c = c.getParent();
        }
        return null;
    }

    public static IActionBars findActionBars(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof CompareEditor) {
                return ((CompareEditor)((Object)data)).getActionBars();
            }
            if (data instanceof IViewPart) {
                return ((IViewPart)data).getViewSite().getActionBars();
            }
            c = c.getParent();
        }
        return null;
    }

    public static void setEnableComposite(Composite composite, boolean enable) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enable);
            ++n2;
        }
    }

    public static boolean getBoolean(CompareConfiguration cc, String key, boolean dflt) {
        Object value;
        if (cc != null && (value = cc.getProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return dflt;
    }

    public static ICompareFilter[] getCompareFilters(CompareConfiguration cc) {
        Object value;
        if (cc != null && (value = cc.getProperty("COMPARE_FILTERS")) instanceof Map) {
            Map filtersMap = (Map)value;
            return filtersMap.values().toArray(new ICompareFilter[filtersMap.size()]);
        }
        return new ICompareFilter[0];
    }

    public static void firePropertyChange(ListenerList<IPropertyChangeListener> listenerList, Object source, String property, Object old, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, property, old, newValue);
        Utilities.firePropertyChange(listenerList, event);
    }

    public static void firePropertyChange(ListenerList<IPropertyChangeListener> listenerList, PropertyChangeEvent event) {
        if (listenerList == null || listenerList.isEmpty()) {
            return;
        }
        Runnable runnable = () -> {
            for (IPropertyChangeListener listener : listenerList) {
                SafeRunner.run(() -> listener.propertyChange(event));
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    private static ArrayList<IResource> internalGetResources(ISelection selection, Class<? extends IResource> type) {
        ArrayList<IResource> tmp = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            Object[] s;
            Object[] objectArray = s = ((IStructuredSelection)selection).toArray();
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable a;
                Object adapter;
                Object o = objectArray[n2];
                IResource resource = null;
                if (type.isInstance(o)) {
                    resource = (IResource)o;
                } else if (o instanceof ResourceMapping) {
                    try {
                        ResourceTraversal[] travs = ((ResourceMapping)o).getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                        if (travs != null) {
                            ResourceTraversal[] resourceTraversalArray = travs;
                            int n3 = travs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource[] resources;
                                ResourceTraversal trav = resourceTraversalArray[n4];
                                IResource[] iResourceArray = resources = trav.getResources();
                                int n5 = resources.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IResource r = iResourceArray[n6];
                                    if (type.isInstance(r) && r.isAccessible()) {
                                        tmp.add(r);
                                    }
                                    ++n6;
                                }
                                ++n4;
                            }
                        }
                    }
                    catch (CoreException ex) {
                        CompareUIPlugin.log(ex);
                    }
                } else if (o instanceof IAdaptable && type.isInstance(adapter = (a = (IAdaptable)o).getAdapter(IResource.class))) {
                    resource = (IResource)adapter;
                }
                if (resource != null && resource.isAccessible()) {
                    tmp.add(resource);
                }
                ++n2;
            }
        }
        return tmp;
    }

    public static IResource[] getResources(ISelection selection) {
        ArrayList<IResource> tmp = Utilities.internalGetResources(selection, IResource.class);
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static IFile[] getFiles(ISelection selection) {
        ArrayList<IResource> tmp = Utilities.internalGetResources(selection, IFile.class);
        return tmp.toArray(new IFile[tmp.size()]);
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException iOException) {
                Utilities.close(in);
                try {
                    bos.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Utilities.close(in);
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Utilities.close(in);
        try {
            bos.close();
        }
        catch (IOException iOException) {}
        return bos.toByteArray();
    }

    public static IPath getIconPath(Display display) {
        return ICONS_PATH;
    }

    public static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText(Utilities.getString(bundle, labelKey, labelKey));
        a.setToolTipText(Utilities.getString(bundle, tooltipKey, null));
        a.setDescription(Utilities.getString(bundle, descriptionKey, null));
        String relPath = Utilities.getString(bundle, imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.contains("/")) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = CompareUIPlugin.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = CompareUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    public static void initToggleAction(IAction a, ResourceBundle bundle, String prefix, boolean checked) {
        String tooltip = null;
        tooltip = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.unchecked", null);
        if (tooltip == null) {
            tooltip = Utilities.getString(bundle, String.valueOf(prefix) + "tooltip", null);
        }
        if (tooltip != null) {
            a.setToolTipText(tooltip);
        }
        String description = null;
        description = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "description.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "description.unchecked", null);
        if (description == null) {
            description = Utilities.getString(bundle, String.valueOf(prefix) + "description", null);
        }
        if (description != null) {
            a.setDescription(description);
        }
    }

    public static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    public static String getFormattedString(ResourceBundle bundle, String key, String arg) {
        if (bundle != null) {
            try {
                return MessageFormat.format(bundle.getString(key), arg);
            }
            catch (MissingResourceException x) {
                CompareUIPlugin.log(x);
            }
        }
        return "!" + key + "!";
    }

    public static String getString(String key) {
        try {
            return CompareUI.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg) {
        try {
            return MessageFormat.format(CompareUI.getResourceBundle().getString(key), arg);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg0, String arg1) {
        try {
            return MessageFormat.format(CompareUI.getResourceBundle().getString(key), arg0, arg1);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        return Utilities.getString(bundle, key, key);
    }

    public static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException x) {
                CompareUIPlugin.log(x);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    public static boolean validateResource(IResource resource, Shell shell, String title) {
        return Utilities.validateResources(new IResource[]{resource}, shell, title);
    }

    public static boolean validateResources(List<IResource> resources, Shell shell, String title) {
        IResource[] r = resources.toArray(new IResource[resources.size()]);
        return Utilities.validateResources(r, shell, title);
    }

    public static boolean validateResources(IResource[] resources, Shell shell, String title) {
        List<IResource> readOnlyFiles = Utilities.getReadonlyFiles(resources);
        if (readOnlyFiles.isEmpty()) {
            return true;
        }
        Map<IFile, Long> oldTimeStamps = Utilities.createModificationStampMap(readOnlyFiles);
        IFile[] files = readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)shell);
        if (!status.isOK()) {
            String message = Utilities.getString("ValidateEdit.error.unable_to_perform");
            Utilities.displayError(shell, title, status, message);
            return false;
        }
        IStatus modified = null;
        Map<IFile, Long> newTimeStamps = Utilities.createModificationStampMap(readOnlyFiles);
        for (Map.Entry<IFile, Long> entry : newTimeStamps.entrySet()) {
            Status error;
            IFile file = entry.getKey();
            Long newTimeStamp = entry.getValue();
            if (file.isReadOnly()) {
                error = new Status(4, CompareUIPlugin.getPluginId(), 10004, Utilities.getFormattedString("ValidateEdit.error.stillReadonly", file.getFullPath().toString()), null);
                modified = Utilities.addStatus(modified, (IStatus)error);
                continue;
            }
            if (oldTimeStamps.get(file).equals(newTimeStamp)) continue;
            error = new Status(4, CompareUIPlugin.getPluginId(), 10004, Utilities.getFormattedString("ValidateEdit.error.fileModified", file.getFullPath().toString()), null);
            modified = Utilities.addStatus(modified, (IStatus)error);
        }
        if (modified != null) {
            String message = Utilities.getString("ValidateEdit.error.unable_to_perform");
            Utilities.displayError(shell, title, modified, message);
            return false;
        }
        return true;
    }

    private static void displayError(Shell shell, String title, IStatus status, String message) {
        if (Display.getCurrent() != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            Display.getDefault().syncExec(() -> {
                int n = ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
            });
        }
    }

    private static List<IResource> getReadonlyFiles(IResource[] resources) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resource.getType() == 1 && resourceAttributes != null && resourceAttributes.isReadOnly()) {
                readOnlyFiles.add(resource);
            }
            ++n2;
        }
        return readOnlyFiles;
    }

    private static Map<IFile, Long> createModificationStampMap(List<IResource> files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        for (IResource file : files) {
            map.put((IFile)file, file.getModificationStamp());
        }
        return map;
    }

    private static IStatus addStatus(IStatus status, IStatus entry) {
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(CompareUIPlugin.getPluginId(), 10004, Utilities.getString("ValidateEdit.error.unable_to_perform"), null);
        result.add(status);
        result.add(entry);
        return result;
    }

    public static String readString(IStreamContentAccessor sca, String encoding) throws CoreException {
        String s = null;
        try {
            try {
                s = Utilities.readString(sca.getContents(), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!encoding.equals(ResourcesPlugin.getEncoding())) {
                    s = Utilities.readString(sca.getContents(), ResourcesPlugin.getEncoding());
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, e.getMessage(), (Throwable)e));
        }
        return s;
    }

    public static String readString(InputStream is, String encoding) throws IOException {
        return Utilities.readString(is, encoding, -1, null);
    }

    public static String readString(InputStream is, String encoding, int length, IProgressMonitor monitor) throws IOException {
        String string;
        block9: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            progress.setWorkRemaining(length);
            if (is == null) {
                return null;
            }
            BufferedReader reader = null;
            try {
                StringBuilder buffer = new StringBuilder();
                char[] part = new char[2048];
                int read = 0;
                reader = new BufferedReader(new InputStreamReader(is, encoding));
                while ((read = reader.read(part)) != -1) {
                    buffer.append(part, 0, read);
                    progress.worked(2048);
                    if (!progress.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                string = buffer.toString();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static String getCharset(Object resource) {
        if (resource instanceof IEncodedStorage) {
            try {
                return ((IEncodedStorage)resource).getCharset();
            }
            catch (CoreException ex) {
                CompareUIPlugin.log(ex);
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    public static byte[] getBytes(String s, String encoding) {
        byte[] bytes = null;
        if (s != null) {
            try {
                bytes = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = s.getBytes();
            }
        }
        return bytes;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        String encoding = null;
        if (sa instanceof IEncodedStreamContentAccessor) {
            encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return Utilities.readString(sa, encoding);
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IResource getFirstResource(ISelection selection) {
        IResource[] resources = Utilities.getResources(selection);
        if (resources.length > 0) {
            return resources[0];
        }
        return null;
    }

    public static ITypedElement getLeg(char type, Object input) {
        if (input instanceof ICompareInput) {
            switch (type) {
                case 'A': {
                    return ((ICompareInput)input).getAncestor();
                }
                case 'L': {
                    return ((ICompareInput)input).getLeft();
                }
                case 'R': {
                    return ((ICompareInput)input).getRight();
                }
            }
        }
        return null;
    }

    public static IDocument getDocument(char type, Object element, boolean isUsingDefaultContentProvider, boolean canHaveSharedDocument) {
        IDocumentProvider provider;
        IEditorInput input;
        ISharedDocumentAdapter sda;
        ITypedElement te = Utilities.getLeg(type, element);
        if (te == null) {
            return null;
        }
        if (te instanceof IDocument) {
            return (IDocument)te;
        }
        if (te instanceof IDocumentRange) {
            return ((IDocumentRange)((Object)te)).getDocument();
        }
        if (isUsingDefaultContentProvider && canHaveSharedDocument && (sda = (ISharedDocumentAdapter)Adapters.adapt((Object)te, ISharedDocumentAdapter.class)) != null && (input = sda.getDocumentKey(te)) != null && (provider = SharedDocumentAdapter.getDocumentProvider(input)) != null) {
            return provider.getDocument((Object)input);
        }
        if (te instanceof IStreamContentAccessor) {
            return DocumentManager.get(te);
        }
        return null;
    }

    public static boolean isHunk(Object input) {
        if (input != null && input instanceof DiffNode) {
            ITypedElement right = ((DiffNode)input).getRight();
            if (Adapters.adapt((Object)right, IHunk.class) != null) {
                return true;
            }
            ITypedElement left = ((DiffNode)input).getLeft();
            if (Adapters.adapt((Object)left, IHunk.class) != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHunkOk(Object input) {
        if (input != null && input instanceof DiffNode) {
            ITypedElement right = ((DiffNode)input).getRight();
            HunkResult element = (HunkResult)Adapters.adapt((Object)right, HunkResult.class);
            if (element != null) {
                return element.isOK();
            }
            ITypedElement left = ((DiffNode)input).getLeft();
            element = (HunkResult)Adapters.adapt((Object)left, HunkResult.class);
            if (element != null) {
                return element.isOK();
            }
        }
        return false;
    }

    public static void schedule(Job job, IWorkbenchSite site) {
        IWorkbenchSiteProgressService siteProgress;
        if (site != null && (siteProgress = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            siteProgress.schedule(job, 0L, true);
            return;
        }
        job.schedule();
    }

    public static void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        } else {
            Display.getDefault().syncExec(() -> BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable));
        }
    }

    public static boolean setReadTimeout(URLConnection connection, int timeout) {
        Method[] methods;
        Method[] methodArray = methods = connection.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals("setReadTimeout")) {
                try {
                    method.invoke((Object)connection, timeout);
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
            }
            ++n2;
        }
        return false;
    }

    public static String getURLContents(URL url, IRunnableContext context) throws InvocationTargetException, OperationCanceledException, InterruptedException {
        String[] result = new String[1];
        context.run(true, true, monitor -> {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)PatchMessages.InputPatchPage_URLConnecting, (int)100);
            try {
                URLConnection connection = url.openConnection();
                progress.worked(10);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Utilities.setReadTimeout(connection, 60000);
                progress.setTaskName(PatchMessages.InputPatchPage_URLFetchingContent);
                String enc = connection.getContentEncoding();
                if (enc == null) {
                    enc = ResourcesPlugin.getEncoding();
                }
                stringArray[0] = Utilities.readString(connection.getInputStream(), enc, connection.getContentLength(), (IProgressMonitor)progress.newChild(90));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        });
        return result[0];
    }

    public static String applyCompareFilters(String thisLine, char thisContributor, String otherLine, char otherContributor, ICompareFilter[] filters) {
        IRegion[][] ignoredRegions = new IRegion[filters.length][];
        HashMap<String, Object> input = new HashMap<String, Object>(4);
        input.put("THIS_LINE", thisLine);
        input.put("THIS_CONTRIBUTOR", Character.valueOf(thisContributor));
        input.put("OTHER_LINE", otherLine);
        input.put("OTHER_CONTRIBUTOR", Character.valueOf(otherContributor));
        int i = 0;
        while (i < filters.length) {
            ignoredRegions[i] = filters[i].getFilteredRegions(input);
            ++i;
        }
        boolean[] ignored = new boolean[thisLine.length()];
        IRegion[][] iRegionArrayArray = ignoredRegions;
        int n = ignoredRegions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion[] regions = iRegionArrayArray[n2];
            if (regions != null) {
                IRegion[] iRegionArray = regions;
                int n3 = regions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRegion region = iRegionArray[n4];
                    if (region != null) {
                        int l = 0;
                        while (l < region.getLength()) {
                            ignored[region.getOffset() + l] = true;
                            ++l;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        StringBuilder buffer = new StringBuilder(thisLine.length());
        int i2 = 0;
        while (i2 < ignored.length) {
            if (!ignored[i2]) {
                buffer.append(thisLine.charAt(i2));
            }
            ++i2;
        }
        return buffer.toString();
    }

    public static void executeRunnable(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Utilities.executeRunnable(runnable, true, true);
    }

    public static void executeRunnable(IRunnableWithProgress runnable, boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void setMenuImage(Item item) {
        Image image;
        if (PlatformUI.isWorkbenchRunning()) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_VIEW_MENU");
        } else {
            image = CompareUIPlugin.getImageDescriptor("elcl16/view_menu.png").createImage();
            item.addDisposeListener(e -> {
                Image img = item.getImage();
                if (img != null && !img.isDisposed()) {
                    img.dispose();
                }
            });
        }
        item.setImage(image);
    }
}

