/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Collection;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.utils.CommonUtils;

public class SQLDataTypeResolver
extends TemplateVariableResolver {
    private static final Log log = Log.getLog(SQLDataTypeResolver.class);

    public SQLDataTypeResolver() {
        super("type", "Data type");
    }

    protected String[] resolveAll(TemplateContext context) {
        Collection localDataTypes;
        DBCExecutionContext executionContext = ((DBPContextProvider)context).getExecutionContext();
        if (executionContext == null) {
            return super.resolveAll(context);
        }
        DBPDataTypeProvider dataTypeProvider = (DBPDataTypeProvider)DBUtils.getAdapter(DBPDataTypeProvider.class, (Object)executionContext.getDataSource());
        if (dataTypeProvider != null && !CommonUtils.isEmpty((Collection)(localDataTypes = dataTypeProvider.getLocalDataTypes()))) {
            String[] result = new String[localDataTypes.size()];
            int index = 0;
            for (DBSDataType dataType : localDataTypes) {
                result[index++] = dataType.getName();
            }
            return result;
        }
        return super.resolveAll(context);
    }
}

