/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorTable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorUpdate
extends SQLGeneratorTable {
    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
        Collection<? extends DBSEntityAttribute> keyAttributes = this.getKeyAttributes(monitor, object);
        sql.append("UPDATE ").append(this.getEntityName(object)).append(this.getLineSeparator()).append("SET ");
        boolean hasAttr = false;
        for (DBSAttributeBase dBSAttributeBase : this.getValueAttributes(monitor, object, keyAttributes)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
            this.appendDefaultValue(sql, dBSAttributeBase);
            hasAttr = true;
        }
        if (!CommonUtils.isEmpty(keyAttributes)) {
            sql.append(this.getLineSeparator()).append("WHERE ");
            hasAttr = false;
            for (DBSEntityAttribute dBSEntityAttribute : keyAttributes) {
                if (hasAttr) {
                    sql.append(" AND ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                this.appendDefaultValue(sql, (DBSAttributeBase)dBSEntityAttribute);
                hasAttr = true;
            }
        }
        sql.append(";\n");
    }
}

