/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jkiss.dbeaver.erd.ui.action.DiagramLayoutAction;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;

public class ERDEditorContextMenuProvider
extends MenuManager
implements IMenuListener {
    private ERDEditorPart editor;

    ERDEditorContextMenuProvider(ERDEditorPart editor) {
        super("ERD Editor Context Menu", "#ERDEditorContext");
        this.editor = editor;
        this.addMenuListener(this);
        this.setRemoveAllWhenShown(true);
        editor.getEditorSite().registerContextMenu("#ERDEditorContext", (MenuManager)this, editor.getEditorSite().getSelectionProvider(), false);
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.buildContextMenu(menu);
    }

    private void buildContextMenu(IMenuManager menu) {
        if (this.editor.isLoaded()) {
            menu.add((IContributionItem)new Separator("edit"));
            ISelection selection = this.editor.getGraphicalViewer().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                this.editor.fillPartContextMenu(menu, (IStructuredSelection)selection);
            }
            menu.add((IContributionItem)new Separator());
            this.editor.fillAttributeVisibilityMenu(menu);
            menu.add((IAction)new DiagramLayoutAction(this.editor));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new Separator("org.eclipse.gef.group.undo"));
            menu.add((IContributionItem)new Separator("org.eclipse.gef.group.copy"));
            menu.add((IContributionItem)new Separator("org.eclipse.gef.group.view"));
            menu.add((IContributionItem)new Separator("org.eclipse.gef.group.find"));
            menu.add((IContributionItem)new Separator("org.eclipse.gef.group.save"));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("tools"));
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)new GroupMarker("additions_end"));
        }
    }
}

