/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.CommonUtils;

public class TextWithOpenFile
extends TextWithOpen {
    private final String title;
    private final String[] filterExt;
    private boolean openFolder = false;

    public TextWithOpenFile(Composite parent, String title, String[] filterExt) {
        super(parent);
        this.title = title;
        this.filterExt = filterExt;
    }

    public void setOpenFolder(boolean openFolder) {
        this.openFolder = openFolder;
    }

    @Override
    protected void openBrowser() {
        String selected;
        String directory = this.getDialogDirectory();
        if (this.openFolder) {
            DirectoryDialog fd = new DirectoryDialog(this.getShell(), 4100);
            if (directory != null) {
                fd.setFilterPath(directory);
            }
            if (this.title != null) {
                fd.setText(this.title);
            }
            selected = fd.open();
        } else {
            FileDialog fd = new FileDialog(this.getShell(), 4100);
            fd.setText(this.title);
            fd.setFilterExtensions(this.filterExt);
            if (directory != null) {
                DialogUtils.setCurDialogFolder(directory);
            }
            selected = DialogUtils.openFileDialog(fd);
        }
        if (selected != null) {
            this.setText(selected);
        }
    }

    protected String getDialogDirectory() {
        String text = this.getText();
        if (CommonUtils.isEmptyTrimmed((String)text)) {
            return null;
        }
        try {
            Path path = Paths.get(text, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                return path.toString();
            }
            Path parent = path.getParent();
            if (parent != null) {
                return parent.toString();
            }
        }
        catch (InvalidPathException invalidPathException) {}
        return null;
    }
}

