/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class ExasolDataSourceProvider
extends JDBCDataSourceProvider {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    protected String getConnectionPropertyDefaultValue(String name, String value) {
        String ovrValue = connectionsProps.get(name);
        return ovrValue != null ? ovrValue : super.getConnectionPropertyDefaultValue(name, value);
    }

    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        Object connecttimeout;
        Object querytimeout;
        Object propClientName;
        String port = ":8563";
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            port = ":" + connectionInfo.getHostPort();
        }
        Map properties = connectionInfo.getProperties();
        StringBuilder url = new StringBuilder(128);
        url.append("jdbc:exa:").append(connectionInfo.getHostName()).append(port);
        String backupHostList = connectionInfo.getProviderProperty("@dbeaver-backupHostList");
        if (!CommonUtils.isEmpty((String)backupHostList)) {
            url.append(",").append(backupHostList).append(port);
        }
        if (!url.toString().toUpperCase().contains("CLIENTNAME")) {
            String clientName = Platform.getProduct().getName();
            propClientName = properties.get("clientname");
            if (propClientName != null) {
                clientName = propClientName.toString();
            }
            url.append(";clientname=").append(clientName);
        }
        if (!url.toString().toUpperCase().contains("CLIENTVERSION")) {
            String clientVersion = Platform.getProduct().getDefiningBundle().getVersion().toString();
            propClientName = properties.get("clientversion");
            if (propClientName != null) {
                clientVersion = propClientName.toString();
            }
            url.append(";clientversion=").append(clientVersion);
        }
        if ((querytimeout = properties.get("querytimeout")) != null) {
            url.append(";").append("querytimeout").append("=").append(querytimeout);
        }
        if ((connecttimeout = properties.get("connecttimeout")) != null) {
            url.append(";").append("connecttimeout").append("=").append(connecttimeout);
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new ExasolDataSource(monitor, container);
    }
}

