/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.plaintext;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

public class PlainTextPresentation
extends AbstractPresentation
implements IAdaptable {
    public static final int FIRST_ROW_LINE = 2;
    private StyledText text;
    private DBDAttributeBinding curAttribute;
    private StyledTextFindReplaceTarget findReplaceTarget;
    public boolean activated;
    private Color curLineColor;
    private int[] colWidths;
    private StyleRange curLineRange;
    private int totalRows = 0;
    private String curSelection;
    private Font monoFont;
    private boolean showNulls;
    private boolean rightJustifyNumbers;
    private boolean rightJustifyDateTime;
    StringBuilder fixBuffer = new StringBuilder();
    private static PrinterData fgPrinterData = null;

    @Override
    public void createPresentation(final @NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine((Composite)parent);
        this.text = new StyledText(parent, 778);
        this.text.setBlockSelection(true);
        this.text.setCursor(parent.getDisplay().getSystemCursor(19));
        this.text.setMargins(4, 4, 4, 4);
        this.text.setForeground(UIStyles.getDefaultTextForeground());
        this.text.setBackground(UIStyles.getDefaultTextBackground());
        this.text.setTabs(controller.getPreferenceStore().getInt("resultset.text.tab.size"));
        this.text.setTabStops(null);
        this.text.setFont(UIUtils.getMonospaceFont());
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addCaretListener(event -> this.onCursorChange(event.caretOffset));
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlainTextPresentation.this.curSelection = PlainTextPresentation.this.text.getSelectionText();
                PlainTextPresentation.this.fireSelectionChanged((ISelection)new PlainTextSelectionImpl());
            }
        });
        final ScrollBar verticalBar = this.text.getVerticalBar();
        verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (verticalBar.getSelection() + verticalBar.getPageIncrement() >= verticalBar.getMaximum() && controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment") && !controller.isRecordMode() && controller.isHasMoreData()) {
                    controller.readNextSegment();
                }
            }
        });
        this.findReplaceTarget = new StyledTextFindReplaceTarget(this.text);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)this.text);
        this.applyCurrentThemeSettings();
        this.registerContextMenu();
        this.activateTextKeyBindings(controller, (Control)this.text);
        this.trackPresentationControl();
    }

    @Override
    public void dispose() {
        if (this.monoFont != null) {
            UIUtils.dispose((Resource)this.monoFont);
            this.monoFont = null;
        }
        super.dispose();
    }

    @Override
    protected void applyThemeSettings(ITheme currentTheme) {
        this.curLineColor = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.odd.background");
        Font rsFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.sql.resultset.font");
        if (rsFont != null) {
            int fontHeight = rsFont.getFontData()[0].getHeight();
            Font font = UIUtils.getMonospaceFont();
            FontData[] fontData = font.getFontData();
            fontData[0].setHeight(fontHeight);
            Font newFont = new Font(font.getDevice(), fontData[0]);
            this.text.setFont(newFont);
            if (this.monoFont != null) {
                UIUtils.dispose((Resource)this.monoFont);
            }
            this.monoFont = newFont;
        }
    }

    private void onCursorChange(int offset) {
        ResultSetModel model = this.controller.getModel();
        int lineNum = this.text.getLineAtOffset(offset);
        int lineOffset = this.text.getOffsetAtLine(lineNum);
        int horizontalOffset = offset - lineOffset;
        int lineCount = this.text.getLineCount();
        boolean delimLeading = this.getController().getPreferenceStore().getBoolean("resultset.text.delimiter.leading");
        int rowNum = lineNum - 2;
        if (this.controller.isRecordMode()) {
            if (rowNum < 0) {
                rowNum = 0;
            }
            if (rowNum >= 0 && rowNum < model.getVisibleAttributeCount()) {
                this.curAttribute = model.getVisibleAttribute(rowNum);
            }
        } else {
            int colNum = 0;
            int horOffsetBegin = 0;
            int horOffsetEnd = 0;
            if (delimLeading) {
                ++horOffsetEnd;
            }
            int i = 0;
            while (i < this.colWidths.length) {
                horOffsetBegin = horOffsetEnd;
                if (horizontalOffset < (horOffsetEnd += this.colWidths[i] + 1)) {
                    colNum = i;
                    break;
                }
                ++i;
            }
            if (rowNum < 0 && model.getRowCount() > 0) {
                rowNum = 0;
            }
            if (rowNum >= 0 && rowNum < model.getRowCount() && colNum >= 0 && colNum < model.getVisibleAttributeCount()) {
                this.controller.setCurrentRow(model.getRow(rowNum));
                this.curAttribute = model.getVisibleAttribute(colNum);
            }
            this.controller.updateEditControls();
            if (this.curLineRange == null || this.curLineRange.start != lineOffset + horOffsetBegin) {
                this.curLineRange = new StyleRange(lineOffset + horOffsetBegin, horOffsetEnd - horOffsetBegin - 1, null, this.curLineColor);
                UIUtils.asyncExec(() -> {
                    this.text.setStyleRanges(new StyleRange[]{this.curLineRange});
                    this.text.redraw();
                });
            }
            if (lineNum == lineCount - 1 && this.controller.isHasMoreData() && this.controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment")) {
                this.controller.readNextSegment();
            }
        }
        this.fireSelectionChanged((ISelection)new PlainTextSelectionImpl());
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        this.colWidths = null;
        DBPPreferenceStore prefs = this.getController().getPreferenceStore();
        this.rightJustifyNumbers = prefs.getBoolean("resultset.show.rightJustifyNumbers");
        this.rightJustifyDateTime = prefs.getBoolean("resultset.show.rightJustifyDateTime");
        if (this.controller.isRecordMode()) {
            this.printRecord();
        } else {
            this.printGrid(append);
        }
    }

    private void printGrid(boolean append) {
        String displayString;
        Object attr;
        int i;
        int extraSpacesNum;
        DBPPreferenceStore prefs = this.getController().getPreferenceStore();
        int maxColumnSize = prefs.getInt("resultset.text.max.column.size");
        boolean delimLeading = prefs.getBoolean("resultset.text.delimiter.leading");
        boolean delimTrailing = prefs.getBoolean("resultset.text.delimiter.trailing");
        boolean delimTop = prefs.getBoolean("resultset.text.delimiter.top");
        boolean delimBottom = prefs.getBoolean("resultset.text.delimiter.bottom");
        boolean extraSpaces = prefs.getBoolean("resultset.text.extra.spaces");
        this.showNulls = this.getController().getPreferenceStore().getBoolean("resultset.text.show.nulls");
        DBDDisplayFormat displayFormat = DBDDisplayFormat.safeValueOf((String)prefs.getString("resultset.text.value.format"));
        StringBuilder grid = new StringBuilder(512);
        ResultSetModel model = this.controller.getModel();
        List<DBDAttributeBinding> attrs = model.getVisibleAttributes();
        List<ResultSetRow> allRows = model.getAllRows();
        int n = extraSpacesNum = extraSpaces ? 2 : 0;
        if (this.colWidths == null) {
            this.colWidths = new int[attrs.size()];
            i = 0;
            while (i < attrs.size()) {
                attr = attrs.get(i);
                this.colWidths[i] = PlainTextPresentation.getAttributeName((DBDAttributeBinding)attr).length() + extraSpacesNum;
                if (this.showNulls && !attr.isRequired()) {
                    this.colWidths[i] = Math.max(this.colWidths[i], "[NULL]".length());
                }
                for (ResultSetRow row : allRows) {
                    displayString = this.getCellString(model, (DBDAttributeBinding)attr, row, displayFormat);
                    this.colWidths[i] = Math.max(this.colWidths[i], this.getStringWidth(displayString) + extraSpacesNum);
                }
                ++i;
            }
            i = 0;
            while (i < this.colWidths.length) {
                if (this.colWidths[i] > maxColumnSize) {
                    this.colWidths[i] = maxColumnSize;
                }
                ++i;
            }
        }
        if (delimTop) {
            this.printSeparator(delimLeading, delimTrailing, this.colWidths, grid);
        }
        if (delimLeading) {
            grid.append("|");
        }
        i = 0;
        while (i < attrs.size()) {
            if (i > 0) {
                grid.append("|");
            }
            if (extraSpaces) {
                grid.append(" ");
            }
            attr = attrs.get(i);
            String attrName = PlainTextPresentation.getAttributeName((DBDAttributeBinding)attr);
            grid.append(attrName);
            int k = this.colWidths[i] - attrName.length() - extraSpacesNum;
            while (k > 0) {
                grid.append(" ");
                --k;
            }
            if (extraSpaces) {
                grid.append(" ");
            }
            ++i;
        }
        if (delimTrailing) {
            grid.append("|");
        }
        grid.append("\n");
        this.printSeparator(delimLeading, delimTrailing, this.colWidths, grid);
        for (ResultSetRow row : allRows) {
            if (delimLeading) {
                grid.append("|");
            }
            int k = 0;
            while (k < attrs.size()) {
                int j;
                DBPDataKind dataKind;
                DBDAttributeBinding attr2;
                if (k > 0) {
                    grid.append("|");
                }
                if ((displayString = this.getCellString(model, attr2 = attrs.get(k), row, displayFormat)).length() >= this.colWidths[k]) {
                    displayString = CommonUtils.truncateString((String)displayString, (int)this.colWidths[k]);
                }
                int stringWidth = this.getStringWidth(displayString);
                if (extraSpaces) {
                    grid.append(" ");
                }
                if ((dataKind = attr2.getDataKind()) == DBPDataKind.NUMERIC && this.rightJustifyNumbers || dataKind == DBPDataKind.DATETIME && this.rightJustifyDateTime) {
                    j = this.colWidths[k] - stringWidth - extraSpacesNum;
                    while (j > 0) {
                        grid.append(" ");
                        --j;
                    }
                    grid.append(displayString);
                } else {
                    grid.append(displayString);
                    j = this.colWidths[k] - stringWidth - extraSpacesNum;
                    while (j > 0) {
                        grid.append(" ");
                        --j;
                    }
                }
                if (extraSpaces) {
                    grid.append(" ");
                }
                ++k;
            }
            if (delimTrailing) {
                grid.append("|");
            }
            grid.append("\n");
        }
        if (delimBottom) {
            this.printSeparator(delimLeading, delimTrailing, this.colWidths, grid);
        }
        grid.setLength(grid.length() - 1);
        int topIndex = this.text.getTopIndex();
        int horizontalIndex = this.text.getHorizontalIndex();
        int caretOffset = this.text.getCaretOffset();
        this.text.setText(grid.toString());
        if (append) {
            this.text.setTopIndex(topIndex);
            this.text.setHorizontalIndex(horizontalIndex);
            this.text.setCaretOffset(caretOffset);
        }
        this.totalRows = allRows.size();
    }

    private int getStringWidth(String str) {
        int width = 0;
        if (str != null && str.length() > 0) {
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                width = c == '\t' ? (width += this.controller.getPreferenceStore().getInt("resultset.text.tab.size")) : ++width;
                ++i;
            }
        }
        return width;
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getCellString(ResultSetModel model, DBDAttributeBinding attr, ResultSetRow row, DBDDisplayFormat displayFormat) {
        String displayString;
        Object cellValue = model.getCellValue(attr, row);
        if (cellValue instanceof DBDValueError) {
            return ((DBDValueError)cellValue).getErrorTitle();
        }
        if (cellValue instanceof Number && this.controller.getPreferenceStore().getBoolean("resultset.format.numeric.native")) {
            displayFormat = DBDDisplayFormat.NATIVE;
        }
        if ((displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, cellValue, displayFormat)).isEmpty() && this.showNulls && DBUtils.isNullValue((Object)cellValue)) {
            displayString = "[NULL]";
        }
        this.fixBuffer.setLength(0);
        int i = 0;
        while (i < displayString.length()) {
            block10: {
                char c = displayString.charAt(i);
                switch (c) {
                    case '\n': {
                        c = '\u00b6';
                        break;
                    }
                    case '\r': {
                        break block10;
                    }
                    case '\u0000': 
                    case '\t': 
                    case '\u00ff': {
                        c = ' ';
                    }
                }
                if (c < ' ') {
                    c = ' ';
                }
                this.fixBuffer.append(c);
            }
            ++i;
        }
        return this.fixBuffer.toString();
    }

    private void printRecord() {
        DBPPreferenceStore prefs = this.getController().getPreferenceStore();
        boolean delimLeading = prefs.getBoolean("resultset.text.delimiter.leading");
        boolean delimTrailing = prefs.getBoolean("resultset.text.delimiter.trailing");
        boolean delimTop = prefs.getBoolean("resultset.text.delimiter.top");
        boolean delimBottom = prefs.getBoolean("resultset.text.delimiter.bottom");
        DBDDisplayFormat displayFormat = DBDDisplayFormat.safeValueOf((String)prefs.getString("resultset.text.value.format"));
        boolean extraSpaces = prefs.getBoolean("resultset.text.extra.spaces");
        String indent = extraSpaces ? " " : "";
        StringBuilder grid = new StringBuilder(512);
        ResultSetModel model = this.controller.getModel();
        List<DBDAttributeBinding> attrs = model.getVisibleAttributes();
        String[] values = new String[attrs.size()];
        ResultSetRow currentRow = this.controller.getCurrentRow();
        int nameWidth = 4;
        int valueWidth = 5;
        int i = 0;
        while (i < attrs.size()) {
            DBDAttributeBinding attr = attrs.get(i);
            nameWidth = Math.max(nameWidth, PlainTextPresentation.getAttributeName(attr).length());
            if (currentRow != null) {
                String displayString;
                values[i] = displayString = this.getCellString(model, attr, currentRow, displayFormat);
                valueWidth = Math.max(valueWidth, values[i].length());
            }
            ++i;
        }
        int extraSpacesNum = extraSpaces ? 2 : 0;
        int[] colWidths = new int[]{nameWidth + extraSpacesNum, valueWidth + extraSpacesNum};
        if (delimTop) {
            this.printSeparator(delimLeading, delimTrailing, colWidths, grid);
        }
        if (delimLeading) {
            grid.append("|");
        }
        grid.append(indent).append("Name");
        int j = nameWidth - 4;
        while (j > 0) {
            grid.append(" ");
            --j;
        }
        grid.append(indent).append("|").append(indent).append("Value");
        j = valueWidth - 5;
        while (j > 0) {
            grid.append(" ");
            --j;
        }
        grid.append(indent);
        if (delimTrailing) {
            grid.append("|");
        }
        grid.append("\n");
        this.printSeparator(delimLeading, delimTrailing, colWidths, grid);
        if (currentRow != null) {
            int i2 = 0;
            while (i2 < attrs.size()) {
                DBDAttributeBinding attr = attrs.get(i2);
                String name = PlainTextPresentation.getAttributeName(attr);
                if (delimLeading) {
                    grid.append("|");
                }
                grid.append(indent);
                grid.append(name);
                grid.append(indent);
                int j2 = nameWidth - name.length();
                while (j2 > 0) {
                    grid.append(" ");
                    --j2;
                }
                grid.append("|");
                grid.append(indent);
                grid.append(values[i2]);
                j2 = valueWidth - values[i2].length();
                while (j2 > 0) {
                    grid.append(" ");
                    --j2;
                }
                grid.append(indent);
                if (delimTrailing) {
                    grid.append("|");
                }
                grid.append("\n");
                ++i2;
            }
        }
        if (delimBottom) {
            this.printSeparator(delimLeading, delimTrailing, colWidths, grid);
        }
        grid.setLength(grid.length() - 1);
        this.text.setText(grid.toString());
    }

    private void printSeparator(boolean delimLeading, boolean delimTrailing, int[] colWidths, StringBuilder output) {
        if (delimLeading) {
            output.append('+');
        }
        int i = 0;
        while (i < colWidths.length) {
            if (i > 0) {
                output.append('+');
            }
            int k = colWidths[i];
            while (k > 0) {
                output.append('-');
                --k;
            }
            ++i;
        }
        if (delimTrailing) {
            output.append('+');
        }
        output.append('\n');
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
        this.colWidths = null;
        this.curLineRange = null;
        this.totalRows = 0;
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        if (this.controller.isRecordMode()) {
            super.scrollToRow(position);
        } else {
            int lineNum;
            int caretOffset = this.text.getCaretOffset();
            if (caretOffset < 0) {
                caretOffset = 0;
            }
            if ((lineNum = this.text.getLineAtOffset(caretOffset)) < 2) {
                lineNum = 2;
            }
            int lineOffset = this.text.getOffsetAtLine(lineNum);
            int xOffset = caretOffset - lineOffset;
            int totalLines = this.text.getLineCount();
            switch (position) {
                case FIRST: {
                    lineNum = 2;
                    break;
                }
                case PREVIOUS: {
                    --lineNum;
                    break;
                }
                case NEXT: {
                    ++lineNum;
                    break;
                }
                case LAST: {
                    lineNum = totalLines - 1;
                    break;
                }
                case CURRENT: {
                    lineNum = this.controller.getCurrentRow().getVisualNumber() + 2;
                }
            }
            if (lineNum < 2 || lineNum >= totalLines) {
                return;
            }
            int newOffset = this.text.getOffsetAtLine(lineNum);
            this.text.setCaretOffset(newOffset += xOffset);
            this.text.showSelection();
        }
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        return Collections.singletonMap(TextTransfer.getInstance(), this.text.getSelectionText());
    }

    @Override
    public void printResultSet() {
        Shell shell = this.getControl().getShell();
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        if (Printer.getPrinterList().length == 0) {
            UIUtils.showMessageBox((Shell)shell, (String)"No printers", (String)"Printers not found", (int)1);
            return;
        }
        PrintDialog dialog = new PrintDialog(shell, 32768);
        dialog.setPrinterData(fgPrinterData);
        PrinterData data = dialog.open();
        if (data != null) {
            final Printer printer = new Printer(data);
            final Runnable styledTextPrinter = this.text.print(printer, options);
            new Thread("Printing"){

                @Override
                public void run() {
                    styledTextPrinter.run();
                    printer.dispose();
                }
            }.start();
            fgPrinterData = data;
            PlainTextPresentation.fgPrinterData.startPage = 1;
            PlainTextPresentation.fgPrinterData.endPage = 1;
            PlainTextPresentation.fgPrinterData.scope = 0;
            PlainTextPresentation.fgPrinterData.copyCount = 1;
        }
    }

    @Override
    protected void performHorizontalScroll(int scrollCount) {
        ScrollBar hsb = this.text.getHorizontalBar();
        if (hsb != null && hsb.isVisible()) {
            int curPosition = this.text.getHorizontalPixel();
            int pageIncrement = UIUtils.getFontHeight((Font)this.text.getFont()) * 10;
            if (scrollCount > 0) {
                if (curPosition > 0) {
                    curPosition -= pageIncrement;
                }
            } else {
                curPosition += pageIncrement;
            }
            if (curPosition < 0) {
                curPosition = 0;
            }
            this.text.setHorizontalPixel(curPosition);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    @Override
    public ISelection getSelection() {
        return new PlainTextSelectionImpl();
    }

    private class PlainTextSelectionImpl
    implements IResultSetSelection {
        private PlainTextSelectionImpl() {
        }

        @Nullable
        public Object getFirstElement() {
            return PlainTextPresentation.this.curSelection;
        }

        public Iterator<String> iterator() {
            return this.toList().iterator();
        }

        public int size() {
            return PlainTextPresentation.this.curSelection == null ? 0 : 1;
        }

        public Object[] toArray() {
            Object[] objectArray;
            if (PlainTextPresentation.this.curSelection == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = PlainTextPresentation.this.curSelection;
            }
            return objectArray;
        }

        public List<String> toList() {
            return PlainTextPresentation.this.curSelection == null ? Collections.emptyList() : Collections.singletonList(PlainTextPresentation.this.curSelection);
        }

        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return PlainTextPresentation.this.controller;
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            if (PlainTextPresentation.this.curAttribute == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(PlainTextPresentation.this.curAttribute);
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            ResultSetRow currentRow = PlainTextPresentation.this.controller.getCurrentRow();
            if (currentRow == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(currentRow);
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            return PlainTextPresentation.this.curAttribute;
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return this.getController().getCurrentRow();
        }
    }
}

