/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSourceObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class MySQLEvent
implements MySQLSourceObject,
DBPSaveableObject,
DBPQualifiedObject {
    private static final String CAT_DETAILS = "Details";
    private static final String CAT_STATS = "Statistics";
    private MySQLCatalog catalog;
    private boolean persisted;
    private String name;
    private String definer;
    private String timeZone;
    private String eventBody;
    private String eventDefinition;
    private String eventType;
    private Date executeAt;
    private String intervalValue;
    private String intervalField;
    private String sqlMode;
    private Date starts;
    private Date ends;
    private String status;
    private String onCompletion;
    private Date created;
    private Date lastAltered;
    private Date lastExecuted;
    private String eventComment;
    private long originator;
    private MySQLCharset characterSetClient;
    private MySQLCollation collationConnection;
    private MySQLCollation databaseCollation;
    private transient String eventFullDefinitionText;

    public MySQLEvent(MySQLCatalog catalog, ResultSet dbResult) throws SQLException {
        this.catalog = catalog;
        this.persisted = true;
        this.loadInfo(dbResult);
    }

    public MySQLEvent(MySQLCatalog catalog, String name) {
        this.catalog = catalog;
        this.name = name;
        this.persisted = false;
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_NAME");
        this.definer = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFINER");
        this.timeZone = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TIME_ZONE");
        this.eventBody = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_BODY");
        this.eventDefinition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_DEFINITION");
        this.eventType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_TYPE");
        this.executeAt = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"EXECUTE_AT");
        this.intervalValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTERVAL_VALUE");
        this.intervalField = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTERVAL_FIELD");
        this.sqlMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_MODE");
        this.starts = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STARTS");
        this.ends = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ENDS");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS");
        this.onCompletion = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ON_COMPLETION");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
        this.lastExecuted = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_EXECUTED");
        this.eventComment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_COMMENT");
        this.originator = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ORIGINATOR");
        this.characterSetClient = this.getDataSource().getCharset(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARACTER_SET_CLIENT"));
        this.collationConnection = this.getDataSource().getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATION_CONNECTION"));
        this.databaseCollation = this.getDataSource().getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATABASE_COLLATION"));
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, category="Details", order=100)
    @Nullable
    public String getDescription() {
        return this.eventComment;
    }

    public DBSObject getParentObject() {
        return this.catalog;
    }

    public MySQLDataSource getDataSource() {
        return this.catalog.getDataSource();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, order=10)
    public String getEventType() {
        return this.eventType;
    }

    @Property(viewable=true, order=11)
    public Date getExecuteAt() {
        return this.executeAt;
    }

    @Property(viewable=true, order=12)
    public String getIntervalValue() {
        return this.intervalValue;
    }

    @Property(viewable=true, order=13)
    public String getIntervalField() {
        return this.intervalField;
    }

    @Property(viewable=true, category="Details", order=14)
    public String getEventBody() {
        return this.eventBody;
    }

    @Property(category="Details", order=30)
    public String getDefiner() {
        return this.definer;
    }

    @Property(category="Details", order=31)
    public String getTimeZone() {
        return this.timeZone;
    }

    @Property(category="Details", order=32)
    public String getSqlMode() {
        return this.sqlMode;
    }

    @Property(category="Details", order=33)
    public Date getStarts() {
        return this.starts;
    }

    @Property(category="Details", order=34)
    public Date getEnds() {
        return this.ends;
    }

    @Property(category="Statistics", order=35)
    public String getStatus() {
        return this.status;
    }

    @Property(category="Details", order=36)
    public String getOnCompletion() {
        return this.onCompletion;
    }

    @Property(category="Statistics", order=37)
    public Date getCreated() {
        return this.created;
    }

    @Property(category="Statistics", order=38)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(category="Statistics", order=39)
    public Date getLastExecuted() {
        return this.lastExecuted;
    }

    @Property(category="Details", order=40)
    public long getOriginator() {
        return this.originator;
    }

    @Property(category="Details", order=41)
    public MySQLCharset getCharacterSetClient() {
        return this.characterSetClient;
    }

    @Property(category="Details", order=42)
    public MySQLCollation getCollationConnection() {
        return this.collationConnection;
    }

    @Property(category="Details", order=43)
    public MySQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.eventFullDefinitionText != null) {
            return this.eventFullDefinitionText;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuilder sql = new StringBuilder();
        sql.append(CommonUtils.getOption(options, (String)"object.alter") ? "ALTER" : "CREATE");
        sql.append(" EVENT ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append("\n");
        if (this.intervalValue != null && this.intervalField != null) {
            sql.append("ON SCHEDULE EVERY ").append(this.intervalValue).append(" ").append(this.intervalField).append("\n");
        } else if (this.executeAt != null) {
            sql.append("ON SCHEDULE AT '").append(dateFormat.format(this.executeAt)).append("'\n");
        } else {
            sql.append("ON SCHEDULE AT CURRENT_TIMESTAMP\n");
        }
        if (this.starts != null) {
            sql.append("STARTS '").append(dateFormat.format(this.starts)).append("'\n");
        }
        if (this.ends != null) {
            sql.append("ENDS '").append(dateFormat.format(this.ends)).append("'\n");
        }
        if (!CommonUtils.isEmpty((String)this.onCompletion)) {
            sql.append("ON COMPLETION ").append(this.onCompletion).append("\n");
        }
        sql.append("ENABLED".equals(this.status) ? "ENABLE" : ("DISABLED".equals(this.status) ? "DISABLE" : "DISABLE ON SLAVE")).append("\n");
        if (!CommonUtils.isEmpty((String)this.eventComment)) {
            sql.append("COMMENT '").append(SQLUtils.escapeString((DBPDataSource)this.getDataSource(), (String)this.eventComment)).append("'\n");
        }
        sql.append("DO ").append(this.eventDefinition);
        return sql.toString();
    }

    public void setEventDefinition(String eventDefinition) {
        this.eventDefinition = eventDefinition;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
        this.eventFullDefinitionText = sourceText;
    }

    public MySQLCatalog getCatalog() {
        return this.catalog;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.catalog, this});
    }
}

