/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.DBASessionContext;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class ProjectMetadata
implements DBPProject {
    private static final Log log = Log.getLog(ProjectMetadata.class);
    public static final String SETTINGS_STORAGE_FILE = "project-settings.json";
    public static final String METADATA_STORAGE_FILE = "project-metadata.json";
    public static final String PROP_PROJECT_ID = "id";
    private static Gson METADATA_GSON = new GsonBuilder().setLenient().serializeNulls().create();
    private final AbstractJob metadataSyncJob;
    private final DBPWorkspace workspace;
    private final IProject project;
    private final DBASessionContext sessionContext;
    private String projectName;
    private File projectPath;
    private volatile ProjectFormat format = ProjectFormat.UNKNOWN;
    private volatile DataSourceRegistry dataSourceRegistry;
    private volatile TaskManagerImpl taskManager;
    private volatile Map<String, Object> properties;
    private volatile Map<String, Map<String, Object>> resourceProperties;
    private DBASecureStorage secureStorage;
    private UUID projectID;
    private final Object metadataSync = new Object();
    private boolean inMemory;

    public ProjectMetadata(DBPWorkspace workspace, IProject project, DBASessionContext sessionContext) {
        this.workspace = workspace;
        this.project = project;
        this.metadataSyncJob = new ProjectSyncJob();
        this.sessionContext = sessionContext == null ? workspace.getAuthContext() : sessionContext;
    }

    public ProjectMetadata(DBPWorkspace workspace, String name, File path, DBASessionContext sessionContext) {
        this(workspace, workspace.getActiveProject() == null ? null : workspace.getActiveProject().getEclipseProject(), sessionContext);
        this.projectName = name;
        this.projectPath = path;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    @NotNull
    public DBPWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean isVirtual() {
        return this.projectName != null;
    }

    @NotNull
    public String getName() {
        return this.projectName != null ? this.projectName : this.project.getName();
    }

    public UUID getProjectID() {
        if (this.projectID == null) {
            String idStr = CommonUtils.toString((Object)this.getProjectProperty(PROP_PROJECT_ID), null);
            if (CommonUtils.isEmpty((String)idStr)) {
                this.projectID = UUID.randomUUID();
                this.setProjectProperty(PROP_PROJECT_ID, this.projectID.toString());
            } else {
                this.projectID = UUID.fromString(idStr);
            }
        }
        return this.projectID;
    }

    @NotNull
    public File getAbsolutePath() {
        return this.projectPath != null ? this.projectPath : this.project.getLocation().toFile();
    }

    @NotNull
    public IProject getEclipseProject() {
        return this.project;
    }

    @NotNull
    public File getMetadataFolder(boolean create) {
        File metadataFolder = new File(this.getAbsolutePath(), ".dbeaver");
        if (create && !metadataFolder.exists() && !metadataFolder.mkdirs()) {
            log.error((Object)"Error creating metadata folder");
        }
        return metadataFolder;
    }

    @NotNull
    private File getMetadataPath() {
        return new File(this.getAbsolutePath(), ".dbeaver");
    }

    public boolean isOpen() {
        return this.project == null || this.project.isOpen();
    }

    public void ensureOpen() throws IllegalStateException {
        if (this.format != ProjectFormat.UNKNOWN) {
            return;
        }
        if (this.project != null && !this.project.isOpen()) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.project.open((IProgressMonitor)monitor);
                this.project.refreshLocal(1, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                log.error((Object)"Error opening project", (Throwable)e);
                return;
            }
        }
        if (this.inMemory) {
            this.format = ProjectFormat.MODERN;
            return;
        }
        File mdFolder = this.getMetadataFolder(false);
        File dsConfig = new File(this.getAbsolutePath(), ".dbeaver-data-sources.xml");
        this.format = !mdFolder.exists() && dsConfig.exists() ? ProjectFormat.LEGACY : ProjectFormat.MODERN;
        this.checkAndUpdateProjectStructure();
    }

    public boolean isRegistryLoaded() {
        return this.dataSourceRegistry != null;
    }

    public boolean isModernProject() {
        return this.getFormat() == ProjectFormat.MODERN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBPDataSourceRegistry getDataSourceRegistry() {
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.dataSourceRegistry == null) {
                this.dataSourceRegistry = new DataSourceRegistry(this.workspace.getPlatform(), this);
            }
        }
        return this.dataSourceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBTTaskManager getTaskManager() {
        this.ensureOpen();
        if (this.taskManager == null) {
            Object object = this.metadataSync;
            synchronized (object) {
                if (this.taskManager == null) {
                    this.taskManager = new TaskManagerImpl(this);
                }
            }
        }
        return this.taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBASecureStorage getSecureStorage() {
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.secureStorage == null) {
                this.secureStorage = this.workspace.getPlatform().getApplication().getProjectSecureStorage((DBPProject)this);
            }
        }
        return this.secureStorage;
    }

    @NotNull
    public DBASessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProjectProperty(String propName) {
        ProjectMetadata projectMetadata = this;
        synchronized (projectMetadata) {
            this.loadProperties();
            return this.properties.get(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectProperty(String propName, Object propValue) {
        ProjectMetadata projectMetadata = this;
        synchronized (projectMetadata) {
            this.loadProperties();
            if (propValue == null) {
                this.properties.remove(propName);
            } else {
                this.properties.put(propName, propValue);
            }
            this.saveProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        if (this.properties != null) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            File settingsFile = new File(this.getMetadataPath(), SETTINGS_STORAGE_FILE);
            if (settingsFile.exists() && settingsFile.length() > 0L) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStreamReader settingsReader = new InputStreamReader((InputStream)new FileInputStream(settingsFile), StandardCharsets.UTF_8);){
                        this.properties = JSONUtils.parseMap((Gson)METADATA_GSON, (Reader)settingsReader);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' setting from " + settingsFile.getAbsolutePath()), e);
                }
            }
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
        }
    }

    private void saveProperties() {
        File settingsFile = new File(this.getMetadataPath(), SETTINGS_STORAGE_FILE);
        String settingsString = METADATA_GSON.toJson(this.properties);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter settingsWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(settingsFile), StandardCharsets.UTF_8);){
                settingsWriter.write(settingsString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error writing project '" + this.getName() + "' setting to " + settingsFile.getAbsolutePath()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResourceProperty(IResource resource, String propName) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resource.getProjectRelativePath().toString());
            if (resProps != null) {
                return resProps.get(propName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getResourceProperties(IResource resource) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            return this.resourceProperties.get(resource.getProjectRelativePath().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> getResourceProperties() {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            return new LinkedHashMap<String, Map<String, Object>>(this.resourceProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResourceProperty(IResource resource, String propName, Object propValue) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            String filePath = resource.getProjectRelativePath().toString();
            Map<String, Object> resProps = this.resourceProperties.get(filePath);
            if (resProps == null) {
                if (propValue == null) {
                    return;
                }
                resProps = new LinkedHashMap<String, Object>();
                this.resourceProperties.put(filePath, resProps);
            }
            if (propValue == null) {
                if (resProps.remove(propName) == null) {
                    if (!resProps.isEmpty()) {
                        return;
                    }
                    this.resourceProperties.remove(filePath);
                }
            } else {
                Object oldValue = resProps.put(propName, propValue);
                if (Objects.equals(oldValue, propValue)) {
                    return;
                }
            }
        }
        this.flushMetadata();
    }

    public void dispose() {
        if (this.dataSourceRegistry != null) {
            this.dataSourceRegistry.dispose();
        }
    }

    public ProjectFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        if (this.isInMemory()) {
            return;
        }
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                return;
            }
            File mdFile = new File(this.getMetadataPath(), METADATA_STORAGE_FILE);
            if (mdFile.exists() && mdFile.length() > 0L) {
                TreeMap<String, Map<String, Object>> mdCache = new TreeMap<String, Map<String, Object>>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStreamReader mdReader = new InputStreamReader((InputStream)new FileInputStream(mdFile), StandardCharsets.UTF_8);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (JsonReader jsonReader = METADATA_GSON.newJsonReader((Reader)mdReader);){
                            jsonReader.beginObject();
                            while (jsonReader.hasNext()) {
                                String topName = jsonReader.nextName();
                                if (!"resources".equals(topName)) continue;
                                jsonReader.beginObject();
                                while (jsonReader.hasNext()) {
                                    String resourceName = jsonReader.nextName();
                                    HashMap<String, Object> resProperties = new HashMap<String, Object>();
                                    jsonReader.beginObject();
                                    while (jsonReader.hasNext()) {
                                        Object propValue;
                                        String propName = jsonReader.nextName();
                                        switch (jsonReader.peek()) {
                                            case NUMBER: {
                                                propValue = jsonReader.nextDouble();
                                                break;
                                            }
                                            case BOOLEAN: {
                                                propValue = jsonReader.nextBoolean();
                                                break;
                                            }
                                            case NULL: {
                                                propValue = null;
                                                break;
                                            }
                                            default: {
                                                propValue = jsonReader.nextString();
                                            }
                                        }
                                        resProperties.put(propName, propValue);
                                    }
                                    jsonReader.endObject();
                                    if (resProperties.isEmpty()) continue;
                                    mdCache.put(resourceName, resProperties);
                                }
                                jsonReader.endObject();
                            }
                            jsonReader.endObject();
                            this.resourceProperties = mdCache;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' metadata from " + mdFile.getAbsolutePath()), e);
                }
            }
            if (this.resourceProperties == null) {
                this.resourceProperties = new TreeMap<String, Map<String, Object>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateProjectStructure() {
        if (this.format == ProjectFormat.UNKNOWN || this.format == ProjectFormat.MODERN) {
            return;
        }
        File mdConfig = new File(this.getMetadataPath(), METADATA_STORAGE_FILE);
        if (!mdConfig.exists()) {
            log.debug((Object)("Migrate Eclipse resource properties to the project metadata (" + mdConfig.getAbsolutePath() + ")"));
            Map<String, Map<String, Object>> projectResourceProperties = this.extractProjectResourceProperties();
            Object object = this.metadataSync;
            synchronized (object) {
                this.resourceProperties = projectResourceProperties;
            }
            this.flushMetadata();
        }
        this.format = ProjectFormat.MODERN;
    }

    private Map<String, Map<String, Object>> extractProjectResourceProperties() {
        final LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        try {
            BucketTree bucketTree = new BucketTree((Workspace)this.workspace.getEclipseWorkspace(), (Bucket)new PropertyBucket());
            try {
                final IPath projectPath = this.project.getFullPath();
                bucketTree.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry entry) {
                        Object value = entry.getValue();
                        if (value instanceof String[][]) {
                            String[][] bucketProps;
                            String[][] stringArray = bucketProps = (String[][])value;
                            int n = bucketProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] resProps = stringArray[n2];
                                if (resProps.length == 3 && "org.jkiss.dbeaver".equals(resProps[0]) && !"sql-editor-project-id".equals(resProps[1])) {
                                    Map propsMap = result.computeIfAbsent(entry.getPath().makeRelativeTo(projectPath).toString(), s -> new LinkedHashMap());
                                    propsMap.put(resProps[1], resProps[2]);
                                }
                                ++n2;
                            }
                        }
                        return 0;
                    }
                }, projectPath, Integer.MAX_VALUE);
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error extracting project metadata", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushMetadata() {
        if (this.inMemory) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            this.metadataSyncJob.schedule(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResourceFromCache(IPath path) {
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                this.resourceProperties.remove(path.toString());
            }
        }
        this.flushMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResourceCache(IPath oldPath, IPath newPath) {
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> props;
            if (this.resourceProperties != null && (props = this.resourceProperties.remove(oldPath.toString())) != null) {
                this.resourceProperties.put(newPath.toString(), props);
            }
        }
        this.flushMetadata();
    }

    public String toString() {
        return this.getName();
    }

    public static enum ProjectFormat {
        UNKNOWN,
        LEGACY,
        MODERN;

    }

    private class ProjectSyncJob
    extends AbstractJob {
        ProjectSyncJob() {
            super("Project metadata sync");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            this.setName("Project '" + ProjectMetadata.this.getName() + "' sync job");
            ContentUtils.makeFileBackup((File)new File(ProjectMetadata.this.getMetadataFolder(true), ProjectMetadata.METADATA_STORAGE_FILE));
            Object object = ProjectMetadata.this.metadataSync;
            synchronized (object) {
                block29: {
                    File mdFile = new File(ProjectMetadata.this.getMetadataPath(), ProjectMetadata.METADATA_STORAGE_FILE);
                    if (CommonUtils.isEmpty((Map)ProjectMetadata.this.resourceProperties) && !mdFile.exists()) {
                        return Status.OK_STATUS;
                    }
                    try {
                        if (CommonUtils.isEmpty((Map)ProjectMetadata.this.resourceProperties)) break block29;
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (OutputStreamWriter mdWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(mdFile), StandardCharsets.UTF_8);){
                            Throwable throwable2 = null;
                            Object var8_12 = null;
                            try (JsonWriter jsonWriter = METADATA_GSON.newJsonWriter((Writer)mdWriter);){
                                jsonWriter.beginObject();
                                jsonWriter.name("resources");
                                jsonWriter.beginObject();
                                for (Map.Entry resEntry : ProjectMetadata.this.resourceProperties.entrySet()) {
                                    jsonWriter.name((String)resEntry.getKey());
                                    jsonWriter.beginObject();
                                    Map resProps = (Map)resEntry.getValue();
                                    for (Map.Entry propEntry : resProps.entrySet()) {
                                        jsonWriter.name((String)propEntry.getKey());
                                        Object value = propEntry.getValue();
                                        if (value == null) {
                                            jsonWriter.nullValue();
                                            continue;
                                        }
                                        if (value instanceof Number) {
                                            jsonWriter.value((Number)value);
                                            continue;
                                        }
                                        if (value instanceof Boolean) {
                                            jsonWriter.value((Boolean)value);
                                            continue;
                                        }
                                        jsonWriter.value(CommonUtils.toString(value));
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                                jsonWriter.endObject();
                                jsonWriter.flush();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)"Error flushing project metadata", (Throwable)e);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

