/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

class EditMavenArtifactDialog
extends Dialog {
    private DriverLibraryMavenArtifact library;
    private Text groupText;
    private Text artifactText;
    private Text classifierText;
    private Combo versionText;
    private boolean ignoreDependencies;

    public EditMavenArtifactDialog(Shell shell, DriverDescriptor driver, DriverLibraryMavenArtifact library) {
        super(shell);
        this.library = library == null ? new DriverLibraryMavenArtifact(driver, DBPDriverLibrary.FileType.jar, "", "RELEASE") : library;
    }

    public DriverLibraryMavenArtifact getLibrary() {
        return this.library;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UIConnectionMessages.dialog_edit_driver_edit_maven_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.groupText = UIUtils.createLabelText((Composite)composite, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_group_id_label, (String)this.library.getReference().getGroupId());
        this.groupText.setLayoutData((Object)gd);
        this.artifactText = UIUtils.createLabelText((Composite)composite, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_artifact_id_label, (String)this.library.getReference().getArtifactId());
        this.artifactText.setLayoutData((Object)gd);
        this.classifierText = UIUtils.createLabelText((Composite)composite, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_classfier_label, (String)CommonUtils.notEmpty((String)this.library.getReference().getClassifier()));
        this.classifierText.setLayoutData((Object)gd);
        this.versionText = UIUtils.createLabelCombo((Composite)composite, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_version_label, (int)2052);
        this.versionText.setLayoutData((Object)gd);
        this.versionText.setText(this.library.getVersion());
        this.versionText.add("RELEASE");
        this.versionText.add("LATEST");
        final Button ignoreDependenciesCheckbox = UIUtils.createCheckbox((Composite)composite, (String)"Ignore transient dependencies", (String)"Do not include library dependencies", (boolean)this.library.isIgnoreDependencies(), (int)2);
        ignoreDependenciesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMavenArtifactDialog.this.ignoreDependencies = ignoreDependenciesCheckbox.getSelection();
            }
        });
        ModifyListener ml = e -> this.updateButtons();
        this.groupText.addModifyListener(ml);
        this.artifactText.addModifyListener(ml);
        this.classifierText.addModifyListener(ml);
        this.versionText.addModifyListener(ml);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(!CommonUtils.isEmpty((String)this.groupText.getText()) && !CommonUtils.isEmpty((String)this.artifactText.getText()) && !CommonUtils.isEmpty((String)this.versionText.getText()));
    }

    protected void okPressed() {
        String classifier = this.classifierText.getText();
        this.library.setReference(new MavenArtifactReference(this.groupText.getText(), this.artifactText.getText(), CommonUtils.isEmpty((String)classifier) ? null : classifier, this.versionText.getText()));
        this.library.setIgnoreDependencies(this.ignoreDependencies);
        super.okPressed();
    }
}

