/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPInheritedObject;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableConstraintBase
extends JDBCTableConstraint<PostgreTableBase>
implements PostgreObject,
PostgreScriptObject,
DBPInheritedObject {
    private static final Log log = Log.getLog(PostgreTableConstraintBase.class);
    private long oid;
    private String constrDDL;
    private long indexId;
    private boolean isLocal;
    private boolean deferrable;
    private boolean deferred;

    public PostgreTableConstraintBase(PostgreTableBase table, String name, DBSEntityConstraintType constraintType, JDBCResultSet resultSet) throws DBException {
        super((JDBCTable)table, name, null, constraintType, true);
        this.oid = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"oid");
        this.indexId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"conindid");
        this.isLocal = !this.getDataSource().getServerType().supportsInheritance() || this instanceof PostgreTableInheritance || JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"conislocal", (boolean)true);
        this.deferrable = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"condeferrable");
        this.deferred = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"condeferred");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"description");
    }

    public PostgreTableConstraintBase(PostgreTableBase table, String constraintName, DBSEntityConstraintType constraintType) {
        super((JDBCTable)table, constraintName, null, constraintType, false);
    }

    public PostgreTableConstraintBase(DBRProgressMonitor monitor, PostgreTableReal owner, PostgreTableConstraintBase srcConstr) throws DBException {
        super((JDBCTable)owner, (DBSEntityConstraint)srcConstr, false);
        int postfix = 1;
        while (owner.getSchema().getConstraintCache().getObject(monitor, owner.getSchema(), this.getName()) != null) {
            this.setName(String.valueOf(srcConstr.getName()) + "_" + postfix);
            ++postfix;
        }
        this.isLocal = srcConstr.isLocal;
        this.deferrable = srcConstr.deferrable;
        this.deferred = srcConstr.deferred;
        this.description = srcConstr.description;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((PostgreTableBase)this.getTable()).getContainer(), this.getTable(), this});
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)((PostgreTableBase)this.getTable()).getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreTableBase)this.getParentObject()).getDatabase();
    }

    @Property(viewable=false, order=10)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=false, order=11)
    public boolean isDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
    }

    @Property(viewable=false, order=12)
    public boolean isDeferred() {
        return this.deferred;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public PostgreIndex getIndex(DBRProgressMonitor monitor) throws DBException {
        return this.indexId == 0L ? null : ((PostgreTableBase)this.getTable()).getSchema().getIndex(monitor, this.indexId);
    }

    public boolean isInherited() {
        return !this.isLocal;
    }

    abstract void cacheAttributes(DBRProgressMonitor var1, List<? extends PostgreTableConstraintColumn> var2, boolean var3);

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.constrDDL == null && this.isPersisted()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read constraint definition");){
                    this.constrDDL = "CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)this) + " " + JDBCUtils.queryString((JDBCSession)session, (String)"SELECT pg_catalog.pg_get_constraintdef(?)", (Object[])new Object[]{this.getObjectId()});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        if (CommonUtils.getOption(options, (String)"embedded.source")) {
            return this.constrDDL;
        }
        return "ALTER TABLE " + ((PostgreTableBase)this.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + this.constrDDL;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        throw new DBException("Constraints DDL is read-only");
    }
}

